/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.common.wizards.AttributeWizard;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class NewAttributeAction
extends BrowserAction {
    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void run() {
        IEntry entry = null;
        if (this.getInput() instanceof IEntry) {
            entry = (IEntry)this.getInput();
        } else if (this.getSelectedEntries().length > 0) {
            entry = this.getSelectedEntries()[0];
        } else if (this.getSelectedAttributes().length > 0) {
            entry = this.getSelectedAttributes()[0].getEntry();
        } else if (this.getSelectedValues().length > 0) {
            entry = this.getSelectedValues()[0].getAttribute().getEntry();
        }
        if (entry != null) {
            String newAttributeDescription;
            AttributeWizard wizard = new AttributeWizard(Messages.getString("NewAttributeAction.NewAttribute"), true, true, null, entry);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            dialog.create();
            if (dialog.open() == 0 && (newAttributeDescription = wizard.getAttributeDescription()) != null && !"".equals(newAttributeDescription)) {
                IAttribute att = entry.getAttribute(newAttributeDescription);
                if (att == null) {
                    att = new Attribute(entry, newAttributeDescription);
                    entry.addAttribute(att);
                }
                att.addEmptyValue();
            }
        }
    }

    @Override
    public String getText() {
        return Messages.getString("NewAttributeAction.NewAttributeLabel");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/attribute_add.gif");
    }

    @Override
    public String getCommandId() {
        return BrowserCommonConstants.CMD_ADD_ATTRIBUTE;
    }

    @Override
    public boolean isEnabled() {
        if (this.getSelectedSearchResults().length == 1 && this.getSelectedAttributes().length > 0) {
            return false;
        }
        return this.getInput() instanceof IEntry || this.getSelectedEntries().length == 1 || this.getSelectedAttributes().length > 0 || this.getSelectedValues().length > 0;
    }
}

