/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.servlet.RequestVariableResolver;
import org.osgi.framework.Bundle;

public final class LicenseServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    static final String[] LICENSE_FILES = new String[]{"README", "DISCLAIMER", "LICENSE", "NOTICE", "DEPENDENCIES"};
    static final String LABEL = "licenses";
    static final String TITLE = "%licenses.pluginTitle";
    static final String[] CSS = new String[]{"/res/ui/license.css"};
    private final String TEMPLATE = this.readTemplateFile("/templates/license.html");

    public LicenseServlet() {
        super(LABEL, TITLE, "Web Console", CSS);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PathInfo pathInfo = PathInfo.parse(request.getPathInfo());
        if (pathInfo != null) {
            if (!this.sendResource(pathInfo, response)) {
                response.sendError(404, "Cannot send data ..");
            }
        } else {
            super.doGet(request, response);
        }
    }

    @Override
    protected void renderContent(HttpServletRequest request, HttpServletResponse res) throws IOException {
        Bundle[] bundles = this.getBundleContext().getBundles();
        Util.sort(bundles, request.getLocale());
        RequestVariableResolver vars = this.getVariableResolver((ServletRequest)request);
        vars.put("__data__", LicenseServlet.getBundleData(bundles, request.getLocale()));
        res.getWriter().print(this.TEMPLATE);
    }

    private static final String getBundleData(Bundle[] bundles, Locale locale) throws IOException {
        StringWriter json = new StringWriter();
        JSONWriter jw = new JSONWriter(json);
        jw.array();
        for (Bundle bundle : bundles) {
            List<Entry> files = LicenseServlet.findResource(bundle, LICENSE_FILES);
            LicenseServlet.addLicensesFromHeader(bundle, files);
            if (files.isEmpty()) continue;
            jw.object();
            jw.key("bid").value(bundle.getBundleId());
            jw.key("title").value(Util.getName(bundle, locale));
            jw.key("files");
            jw.object();
            jw.key("__res__");
            jw.array();
            Iterator<Entry> iter = files.iterator();
            while (iter.hasNext()) {
                jw.object();
                Entry entry = iter.next();
                jw.key("path").value(entry.path);
                jw.key("url").value(entry.url);
                if (entry.jar != null) {
                    jw.key("jar").value(entry.jar);
                }
                jw.endObject();
            }
            jw.endArray();
            jw.endObject();
            jw.endObject();
        }
        jw.endArray();
        return json.toString();
    }

    private static final String getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private static final void addLicensesFromHeader(Bundle bundle, List<Entry> files) {
        String target = (String)bundle.getHeaders("").get("Bundle-License");
        if (target != null) {
            Clause[] licenses = Parser.parseHeader(target);
            for (int i = 0; licenses != null && i < licenses.length; ++i) {
                String url;
                String path;
                String name = licenses[i].getName();
                if ("<<EXTERNAL>>".equals(name)) continue;
                String link = licenses[i].getAttribute("link");
                if (link == null) {
                    path = name;
                    url = LicenseServlet.getName(name);
                } else {
                    path = link;
                    url = name;
                }
                if (path.indexOf("://") == -1 && null == bundle.getEntry(path)) continue;
                Entry entry = new Entry();
                entry.path = path;
                entry.url = url;
                files.add(entry);
            }
        }
    }

    private static final List<Entry> findResource(Bundle bundle, String[] patterns) throws IOException {
        ArrayList<Entry> files = new ArrayList<Entry>();
        for (int i = 0; i < patterns.length; ++i) {
            Enumeration entries = bundle.findEntries("/", patterns[i] + "*", true);
            if (entries == null) continue;
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                Entry entry = new Entry();
                entry.path = url.getPath();
                entry.url = LicenseServlet.getName(url.getPath());
                files.add(entry);
            }
        }
        Enumeration entries = bundle.findEntries("/", "*.jar", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                try (ZipInputStream zin = new ZipInputStream(url.openStream());){
                    ZipEntry zentry = zin.getNextEntry();
                    while (zentry != null) {
                        String name = zentry.getName();
                        if (!name.endsWith("/")) {
                            name = name.substring(name.lastIndexOf(47) + 1);
                            for (int i = 0; i < patterns.length; ++i) {
                                if (!name.startsWith(patterns[i])) continue;
                                Entry entry = new Entry();
                                entry.path = zentry.getName();
                                entry.url = LicenseServlet.getName(name);
                                entry.jar = url.getPath();
                                files.add(entry);
                            }
                        }
                        zentry = zin.getNextEntry();
                    }
                }
            }
        }
        return files;
    }

    private boolean sendResource(PathInfo pathInfo, HttpServletResponse response) throws IOException {
        String name = pathInfo.licenseFile.substring(pathInfo.licenseFile.lastIndexOf(47) + 1);
        boolean isLicense = false;
        for (int i = 0; !isLicense && i < LICENSE_FILES.length; ++i) {
            isLicense = name.startsWith(LICENSE_FILES[i]);
        }
        Bundle bundle = this.getBundleContext().getBundle(pathInfo.bundleId);
        if (bundle == null) {
            return false;
        }
        WebConsoleUtil.setNoCache(response);
        response.setContentType("text/plain");
        if (pathInfo.innerJar == null) {
            URL resource = bundle.getEntry(pathInfo.licenseFile);
            if (resource == null) {
                resource = bundle.getResource(pathInfo.licenseFile);
            }
            if (resource != null) {
                try (InputStream input = resource.openStream();){
                    this.copy(input, response.getWriter());
                }
                return true;
            }
        } else {
            URL zipResource = bundle.getResource(pathInfo.innerJar);
            if (zipResource != null) {
                try (ZipInputStream zin = new ZipInputStream(zipResource.openStream());){
                    ZipEntry zentry = zin.getNextEntry();
                    while (zentry != null) {
                        if (pathInfo.licenseFile.equals(zentry.getName())) {
                            this.copy(zin, response.getWriter());
                            boolean bl = true;
                            return bl;
                        }
                        zentry = zin.getNextEntry();
                    }
                }
            }
        }
        return false;
    }

    private void copy(InputStream in, Writer out) throws IOException {
        int l;
        InputStreamReader r = new InputStreamReader(in, StandardCharsets.UTF_8);
        char[] buf = new char[4096];
        while ((l = r.read(buf)) > 0) {
            out.write(buf, 0, l);
        }
    }

    static class PathInfo {
        final long bundleId;
        final String innerJar;
        final String licenseFile;

        static PathInfo parse(String pathInfo) {
            String innerJar;
            long bundleId;
            if (pathInfo == null || pathInfo.length() == 0 || !pathInfo.startsWith("/licenses/")) {
                return null;
            }
            String parts = pathInfo.substring(LicenseServlet.LABEL.length() + 2);
            int slash = parts.indexOf(47);
            if (slash <= 0) {
                return null;
            }
            try {
                bundleId = Long.parseLong(parts.substring(0, slash));
                if (bundleId < 0L) {
                    return null;
                }
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            int jarSep = parts.indexOf("!/", slash);
            if (jarSep < 0) {
                innerJar = null;
            } else {
                innerJar = parts.substring(slash, jarSep);
                slash = jarSep + 2;
            }
            String licenseFile = parts.substring(slash);
            return new PathInfo(bundleId, innerJar, licenseFile);
        }

        private PathInfo(long bundleId, String innerJar, String licenseFile) {
            this.bundleId = bundleId;
            this.innerJar = innerJar;
            this.licenseFile = licenseFile;
        }
    }

    public static final class Entry {
        String url;
        String path;
        String jar;
    }
}

