/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.runtime.SpatialTypeFunctions;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlSpatialTypeFunctions;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.ListSqlOperatorTable;
import org.apache.flink.calcite.shaded.com.google.common.base.Suppliers;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class SqlOperatorTables {
    private static final Supplier<SqlOperatorTable> SPATIAL = Suppliers.memoize(SqlOperatorTables::createSpatial)::get;

    private SqlOperatorTables() {
    }

    private static SqlOperatorTable createSpatial() {
        return CalciteCatalogReader.operatorTable(SpatialTypeFunctions.class.getName(), SqlSpatialTypeFunctions.class.getName());
    }

    public static SqlOperatorTable spatialInstance() {
        return SPATIAL.get();
    }

    public static SqlOperatorTable chain(Iterable<SqlOperatorTable> tables) {
        ArrayList<SqlOperatorTable> list = new ArrayList<SqlOperatorTable>();
        for (SqlOperatorTable table : tables) {
            SqlOperatorTables.addFlattened(list, table);
        }
        if (list.size() == 1) {
            return (SqlOperatorTable)list.get(0);
        }
        return new ChainedSqlOperatorTable(ImmutableList.copyOf(list));
    }

    private static void addFlattened(List<SqlOperatorTable> list, SqlOperatorTable table) {
        if (table instanceof ChainedSqlOperatorTable) {
            ChainedSqlOperatorTable chainedTable = (ChainedSqlOperatorTable)table;
            for (SqlOperatorTable table2 : chainedTable.tableList) {
                SqlOperatorTables.addFlattened(list, table2);
            }
        } else if (!(table instanceof ImmutableListSqlOperatorTable) || !table.getOperatorList().isEmpty()) {
            list.add(table);
        }
    }

    public static SqlOperatorTable chain(SqlOperatorTable ... tables) {
        return SqlOperatorTables.chain(ImmutableList.copyOf(tables));
    }

    public static SqlOperatorTable of(Iterable<? extends SqlOperator> list) {
        return new ImmutableListSqlOperatorTable(ImmutableList.copyOf(list));
    }

    public static SqlOperatorTable of(SqlOperator ... operators) {
        return SqlOperatorTables.of(ImmutableList.copyOf(operators));
    }

    private static class ImmutableListSqlOperatorTable
    extends ListSqlOperatorTable {
        ImmutableListSqlOperatorTable(ImmutableList<SqlOperator> operatorList) {
            super(operatorList, false);
        }
    }
}

