/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import org.apache.flink.sql.parser.dql.SqlShowFunctions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlShowFunctionsConverter
implements SqlNodeConverter<SqlShowFunctions> {
    @Override
    public Operation convertSqlNode(SqlShowFunctions sqlShowFunctions, SqlNodeConverter.ConvertContext context) {
        ShowFunctionsOperation.FunctionScope functionScope;
        ShowFunctionsOperation.FunctionScope functionScope2 = functionScope = sqlShowFunctions.requireUser() ? ShowFunctionsOperation.FunctionScope.USER : ShowFunctionsOperation.FunctionScope.ALL;
        if (sqlShowFunctions.getPreposition() == null) {
            return new ShowFunctionsOperation(functionScope, sqlShowFunctions.getLikeType(), sqlShowFunctions.getLikeSqlPattern(), sqlShowFunctions.isNotLike());
        }
        CharSequence[] fullDatabaseName = sqlShowFunctions.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException(String.format("Show functions from/in identifier [ %s ] format error, it should be [catalog_name.]database_name.", String.join((CharSequence)".", fullDatabaseName)));
        }
        CatalogManager catalogManager = context.getCatalogManager();
        CharSequence catalogName = fullDatabaseName.length == 1 ? catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        CharSequence databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        return new ShowFunctionsOperation(functionScope, sqlShowFunctions.getPreposition(), catalogName, (String)databaseName, sqlShowFunctions.getLikeType(), sqlShowFunctions.getLikeSqlPattern(), sqlShowFunctions.isNotLike());
    }
}

