/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.annotation.Internal;
import org.apache.flink.calcite.shaded.com.google.common.collect.BoundType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableRangeSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlAggFunction;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.sql.BuiltInSqlOperator;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.typeutils.SymbolUtil;

@Internal
final class RexNodeJsonDeserializer
extends StdDeserializer<RexNode> {
    private static final long serialVersionUID = 1L;

    RexNodeJsonDeserializer() {
        super(RexNode.class);
    }

    public RexNode deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        SerdeContext serdeContext = SerdeContext.get((DatabindContext)ctx);
        return RexNodeJsonDeserializer.deserialize(jsonNode, serdeContext);
    }

    private static RexNode deserialize(JsonNode jsonNode, SerdeContext serdeContext) throws IOException {
        String kind;
        switch (kind = jsonNode.required("kind").asText()) {
            case "INPUT_REF": {
                return RexNodeJsonDeserializer.deserializeInputRef(jsonNode, serdeContext);
            }
            case "LITERAL": {
                return RexNodeJsonDeserializer.deserializeLiteral(jsonNode, serdeContext);
            }
            case "FIELD_ACCESS": {
                return RexNodeJsonDeserializer.deserializeFieldAccess(jsonNode, serdeContext);
            }
            case "CORREL_VARIABLE": {
                return RexNodeJsonDeserializer.deserializeCorrelVariable(jsonNode, serdeContext);
            }
            case "PATTERN_INPUT_REF": {
                return RexNodeJsonDeserializer.deserializePatternFieldRef(jsonNode, serdeContext);
            }
            case "CALL": {
                return RexNodeJsonDeserializer.deserializeCall(jsonNode, serdeContext);
            }
        }
        throw new TableException("Cannot convert to RexNode: " + jsonNode.toPrettyString());
    }

    private static RexNode deserializeInputRef(JsonNode jsonNode, SerdeContext serdeContext) {
        int inputIndex = jsonNode.required("inputIndex").intValue();
        JsonNode logicalTypeNode = jsonNode.required("type");
        RelDataType fieldType = RelDataTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
        return serdeContext.getRexBuilder().makeInputRef(fieldType, inputIndex);
    }

    private static RexNode deserializeLiteral(JsonNode jsonNode, SerdeContext serdeContext) {
        JsonNode logicalTypeNode = jsonNode.required("type");
        RelDataType relDataType = RelDataTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
        if (jsonNode.has("sarg")) {
            return RexNodeJsonDeserializer.deserializeSarg(jsonNode.required("sarg"), relDataType, serdeContext);
        }
        if (jsonNode.has("value")) {
            Object value = RexNodeJsonDeserializer.deserializeLiteralValue(jsonNode, relDataType.getSqlTypeName(), serdeContext);
            if (value == null) {
                return serdeContext.getRexBuilder().makeNullLiteral(relDataType);
            }
            return serdeContext.getRexBuilder().makeLiteral(value, relDataType, true);
        }
        throw new TableException("Unknown literal: " + jsonNode.toPrettyString());
    }

    private static RexNode deserializeSarg(JsonNode sargNode, RelDataType relDataType, SerdeContext serdeContext) {
        RexBuilder rexBuilder = serdeContext.getRexBuilder();
        ArrayNode rangesNode = (ArrayNode)sargNode.required("ranges");
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (JsonNode rangeNode : rangesNode) {
            Range<Comparable> r;
            BoundType boundType;
            Comparable boundValue;
            Range<Object> range = Range.all();
            if (rangeNode.has("lower")) {
                JsonNode lowerNode = rangeNode.required("lower");
                boundValue = (Comparable)RexNodeJsonDeserializer.deserializeLiteralValue(lowerNode, relDataType.getSqlTypeName(), serdeContext);
                assert (boundValue != null);
                boundType = SymbolUtil.serializableToCalcite(BoundType.class, lowerNode.required("boundType").asText());
                r = boundType == BoundType.OPEN ? Range.greaterThan(boundValue) : Range.atLeast(boundValue);
                range = range.intersection(r);
            }
            if (rangeNode.has("upper")) {
                JsonNode upperNode = rangeNode.required("upper");
                boundValue = (Comparable)RexNodeJsonDeserializer.deserializeLiteralValue(upperNode, relDataType.getSqlTypeName(), serdeContext);
                assert (boundValue != null);
                boundType = SymbolUtil.serializableToCalcite(BoundType.class, upperNode.required("boundType").asText());
                r = boundType == BoundType.OPEN ? Range.lessThan(boundValue) : Range.atMost(boundValue);
                range = range.intersection(r);
            }
            if (!range.hasUpperBound() && !range.hasLowerBound()) continue;
            builder.add(range);
        }
        JsonNode containsNull = sargNode.get("containsNull");
        if (containsNull != null) {
            return rexBuilder.makeSearchArgumentLiteral(Sarg.of(containsNull.booleanValue(), builder.build()), relDataType);
        }
        RexUnknownAs nullAs = SymbolUtil.serializableToCalcite(RexUnknownAs.class, sargNode.required("nullAs").asText());
        return rexBuilder.makeSearchArgumentLiteral(Sarg.of(nullAs, builder.build()), relDataType);
    }

    @Nullable
    private static Object deserializeLiteralValue(JsonNode literalNode, SqlTypeName sqlTypeName, SerdeContext serdeContext) {
        JsonNode valueNode = literalNode.required("value");
        if (valueNode.isNull()) {
            return null;
        }
        switch (sqlTypeName) {
            case BOOLEAN: {
                return valueNode.booleanValue();
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return new BigDecimal(valueNode.asText());
            }
            case DATE: {
                return new DateString(valueNode.asText());
            }
            case TIME: {
                return new TimeString(valueNode.asText());
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new TimestampString(valueNode.asText());
            }
            case BINARY: 
            case VARBINARY: {
                return ByteString.ofBase64(valueNode.asText());
            }
            case CHAR: 
            case VARCHAR: {
                return serdeContext.getRexBuilder().makeLiteral(valueNode.asText()).getValue();
            }
            case SYMBOL: {
                JsonNode symbolNode = literalNode.required("symbol");
                SymbolUtil.SerializableSymbol symbol = SymbolUtil.SerializableSymbol.of(symbolNode.asText(), valueNode.asText());
                return SymbolUtil.serializableToCalcite(symbol);
            }
        }
        throw new TableException("Unknown literal: " + valueNode);
    }

    private static RexNode deserializeFieldAccess(JsonNode jsonNode, SerdeContext serdeContext) throws IOException {
        String fieldName = jsonNode.required("name").asText();
        JsonNode exprNode = jsonNode.required("expr");
        RexNode refExpr = RexNodeJsonDeserializer.deserialize(exprNode, serdeContext);
        return serdeContext.getRexBuilder().makeFieldAccess(refExpr, fieldName, true);
    }

    private static RexNode deserializeCorrelVariable(JsonNode jsonNode, SerdeContext serdeContext) {
        String correl = jsonNode.required("correl").asText();
        JsonNode logicalTypeNode = jsonNode.required("type");
        RelDataType fieldType = RelDataTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
        return serdeContext.getRexBuilder().makeCorrel(fieldType, new CorrelationId(correl));
    }

    private static RexNode deserializePatternFieldRef(JsonNode jsonNode, SerdeContext serdeContext) {
        int inputIndex = jsonNode.required("inputIndex").intValue();
        String alpha = jsonNode.required("alpha").asText();
        JsonNode logicalTypeNode = jsonNode.required("type");
        RelDataType fieldType = RelDataTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
        return serdeContext.getRexBuilder().makePatternFieldRef(alpha, fieldType, inputIndex);
    }

    private static RexNode deserializeCall(JsonNode jsonNode, SerdeContext serdeContext) throws IOException {
        RelDataType callType;
        SqlOperator operator = RexNodeJsonDeserializer.deserializeSqlOperator(jsonNode, serdeContext);
        ArrayNode operandNodes = (ArrayNode)jsonNode.get("operands");
        ArrayList<RexNode> rexOperands = new ArrayList<RexNode>();
        for (JsonNode node : operandNodes) {
            rexOperands.add(RexNodeJsonDeserializer.deserialize(node, serdeContext));
        }
        if (jsonNode.has("type")) {
            JsonNode typeNode = jsonNode.get("type");
            callType = RelDataTypeJsonDeserializer.deserialize(typeNode, serdeContext);
        } else {
            callType = serdeContext.getRexBuilder().deriveReturnType(operator, rexOperands);
        }
        return serdeContext.getRexBuilder().makeCall(callType, operator, rexOperands);
    }

    static SqlOperator deserializeSqlOperator(JsonNode jsonNode, SerdeContext serdeContext) {
        SqlSyntax syntax = jsonNode.has("syntax") ? SymbolUtil.serializableToCalcite(SqlSyntax.class, jsonNode.required("syntax").asText()) : SqlSyntax.FUNCTION;
        if (jsonNode.has("internalName")) {
            return RexNodeJsonDeserializer.deserializeInternalFunction(jsonNode.required("internalName").asText(), syntax, serdeContext);
        }
        if (jsonNode.has("catalogName")) {
            return RexNodeJsonDeserializer.deserializeCatalogFunction(jsonNode, syntax, serdeContext);
        }
        if (jsonNode.has("class")) {
            return RexNodeJsonDeserializer.deserializeFunctionClass(jsonNode, serdeContext);
        }
        if (jsonNode.has("systemName")) {
            return RexNodeJsonDeserializer.deserializeSystemFunction(jsonNode.required("systemName").asText(), syntax, serdeContext);
        }
        if (jsonNode.has("sqlKind")) {
            return RexNodeJsonDeserializer.deserializeInternalFunction(syntax, SqlKind.valueOf(jsonNode.get("sqlKind").asText()));
        }
        throw new TableException("Invalid function call.");
    }

    private static SqlOperator deserializeSystemFunction(String systemName, SqlSyntax syntax, SerdeContext serdeContext) {
        Optional<SqlOperator> systemOperator = RexNodeJsonDeserializer.lookupOptionalSqlOperator(FunctionIdentifier.of((String)systemName), syntax, serdeContext, true);
        if (systemOperator.isPresent()) {
            return systemOperator.get();
        }
        throw RexNodeJsonDeserializer.missingSystemFunction(systemName);
    }

    private static SqlOperator deserializeInternalFunction(String internalName, SqlSyntax syntax, SerdeContext serdeContext) {
        Optional<SqlOperator> internalOperator = RexNodeJsonDeserializer.lookupOptionalSqlOperator(FunctionIdentifier.of((String)internalName), syntax, serdeContext, false);
        if (internalOperator.isPresent()) {
            return internalOperator.get();
        }
        String publicName = BuiltInSqlOperator.extractNameFromQualifiedName(internalName);
        Optional<SqlOperator> latestOperator = RexNodeJsonDeserializer.lookupOptionalSqlOperator(FunctionIdentifier.of((String)publicName), syntax, serdeContext, true);
        if (latestOperator.isPresent()) {
            return latestOperator.get();
        }
        Optional<SqlOperator> sqlStdOperator = RexNodeJsonDeserializer.lookupOptionalSqlStdOperator(publicName, syntax, null);
        if (sqlStdOperator.isPresent()) {
            return sqlStdOperator.get();
        }
        throw new TableException(String.format("Could not resolve internal system function '%s'. This is a bug, please file an issue.", internalName));
    }

    private static SqlOperator deserializeInternalFunction(SqlSyntax syntax, SqlKind sqlKind) {
        Optional<SqlOperator> stdOperator = RexNodeJsonDeserializer.lookupOptionalSqlStdOperator("", syntax, sqlKind);
        if (stdOperator.isPresent()) {
            return stdOperator.get();
        }
        throw new TableException(String.format("Could not resolve internal system function '%s'. This is a bug, please file an issue.", sqlKind.name()));
    }

    private static SqlOperator deserializeFunctionClass(JsonNode jsonNode, SerdeContext serdeContext) {
        ContextResolvedFunction resolvedFunction;
        String className = jsonNode.required("class").asText();
        Class<?> functionClass = JsonSerdeUtil.loadClass(className, serdeContext, "function");
        UserDefinedFunction functionInstance = UserDefinedFunctionHelper.instantiateFunction(functionClass);
        if (jsonNode.has("catalogName")) {
            ObjectIdentifier objectIdentifier = ObjectIdentifierJsonDeserializer.deserialize(jsonNode.required("catalogName").asText(), serdeContext);
            resolvedFunction = ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)objectIdentifier), (FunctionDefinition)functionInstance);
        } else {
            resolvedFunction = ContextResolvedFunction.anonymous((FunctionDefinition)functionInstance);
        }
        switch (functionInstance.getKind()) {
            case SCALAR: 
            case ASYNC_SCALAR: 
            case TABLE: {
                return BridgingSqlFunction.of(serdeContext.getFlinkContext(), serdeContext.getTypeFactory(), resolvedFunction);
            }
            case AGGREGATE: {
                return BridgingSqlAggFunction.of(serdeContext.getFlinkContext(), serdeContext.getTypeFactory(), resolvedFunction);
            }
        }
        throw new TableException(String.format("Unsupported anonymous function kind '%s' for class '%s'.", functionInstance.getKind(), className));
    }

    private static SqlOperator deserializeCatalogFunction(JsonNode jsonNode, SqlSyntax syntax, SerdeContext serdeContext) {
        TableConfigOptions.CatalogPlanRestore restoreStrategy = (TableConfigOptions.CatalogPlanRestore)serdeContext.getConfiguration().get(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS);
        FunctionIdentifier identifier = FunctionIdentifier.of((ObjectIdentifier)ObjectIdentifierJsonDeserializer.deserialize(jsonNode.required("catalogName").asText(), serdeContext));
        switch (restoreStrategy) {
            case ALL: {
                Optional<SqlOperator> lookupOperator = RexNodeJsonDeserializer.lookupOptionalSqlOperator(identifier, syntax, serdeContext, false);
                if (lookupOperator.isPresent()) {
                    return lookupOperator.get();
                }
                if (jsonNode.has("class")) {
                    return RexNodeJsonDeserializer.deserializeFunctionClass(jsonNode, serdeContext);
                }
                throw RexNodeJsonDeserializer.missingFunctionFromCatalog(identifier, false);
            }
            case ALL_ENFORCED: {
                if (jsonNode.has("class")) {
                    return RexNodeJsonDeserializer.deserializeFunctionClass(jsonNode, serdeContext);
                }
                Optional<SqlOperator> lookupOperator = RexNodeJsonDeserializer.lookupOptionalSqlOperator(identifier, syntax, serdeContext, false);
                if (lookupOperator.map(RexNodeJsonDeserializer::isTemporary).orElse(false).booleanValue()) {
                    return lookupOperator.get();
                }
                throw RexNodeJsonDeserializer.lookupDisabled(identifier);
            }
            case IDENTIFIER: {
                Optional<SqlOperator> lookupOperator = RexNodeJsonDeserializer.lookupOptionalSqlOperator(identifier, syntax, serdeContext, true);
                if (lookupOperator.isPresent()) {
                    return lookupOperator.get();
                }
                throw RexNodeJsonDeserializer.missingFunctionFromCatalog(identifier, true);
            }
        }
        throw new TableException("Unsupported restore strategy: " + restoreStrategy);
    }

    private static boolean isTemporary(SqlOperator sqlOperator) {
        if (sqlOperator instanceof BridgingSqlFunction) {
            return ((BridgingSqlFunction)sqlOperator).getResolvedFunction().isTemporary();
        }
        if (sqlOperator instanceof BridgingSqlAggFunction) {
            return ((BridgingSqlAggFunction)sqlOperator).getResolvedFunction().isTemporary();
        }
        return false;
    }

    private static Optional<SqlOperator> lookupOptionalSqlOperator(FunctionIdentifier identifier, SqlSyntax syntax, SerdeContext serdeContext, boolean throwOnError) {
        ArrayList<SqlOperator> foundOperators = new ArrayList<SqlOperator>();
        try {
            serdeContext.getOperatorTable().lookupOperatorOverloads(new SqlIdentifier(identifier.toList(), new SqlParserPos(0, 0)), null, syntax, foundOperators, SqlNameMatchers.liberal());
            if (foundOperators.size() != 1) {
                return Optional.empty();
            }
            return Optional.of(foundOperators.get(0));
        }
        catch (Throwable t) {
            if (throwOnError) {
                throw new TableException(String.format("Error during lookup of function '%s'.", identifier), t);
            }
            return Optional.empty();
        }
    }

    private static Optional<SqlOperator> lookupOptionalSqlStdOperator(String operatorName, SqlSyntax syntax, @Nullable SqlKind sqlKind) {
        ArrayList<SqlOperator> foundOperators = new ArrayList<SqlOperator>();
        SqlStdOperatorTable.instance().lookupOperatorOverloads(new SqlIdentifier(operatorName, new SqlParserPos(0, 0)), null, syntax, foundOperators, SqlNameMatchers.liberal());
        if (foundOperators.size() == 1) {
            return Optional.of(foundOperators.get(0));
        }
        return foundOperators.stream().filter(o -> sqlKind != null && o.getKind() == sqlKind).findFirst();
    }

    private static TableException missingSystemFunction(String systemName) {
        return new TableException(String.format("Could not lookup system function '%s'. Make sure it has been registered before because temporary functions are not contained in the persisted plan. If the function was provided by a module, make sure to reloaded all used modules in the correct order.", systemName));
    }

    private static TableException lookupDisabled(FunctionIdentifier identifier) {
        return new TableException(String.format("The persisted plan does not include all required catalog metadata for function '%s'. However, lookup is disabled because option '%s' = '%s'. Either enable the catalog lookup with '%s' = '%s' / '%s' or regenerate the plan with '%s' != '%s'. Make sure the function is not compiled as a temporary function.", identifier.asSummaryString(), TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED.name(), TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.IDENTIFIER.name(), TableConfigOptions.CatalogPlanRestore.ALL.name(), TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanCompilation.IDENTIFIER.name()));
    }

    private static TableException missingFunctionFromCatalog(FunctionIdentifier identifier, boolean forcedLookup) {
        String initialReason = forcedLookup ? String.format("Cannot resolve function '%s' and catalog lookup is forced because '%s' = '%s'. ", identifier, TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.IDENTIFIER) : String.format("Cannot resolve function '%s' and the persisted plan does not include all required catalog function metadata. ", identifier);
        return new TableException(initialReason + String.format("Make sure a registered catalog contains the function when restoring or the function is available as a temporary function. Otherwise regenerate the plan with '%s' != '%s' and make sure the function was not compiled as a temporary function.", TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanCompilation.IDENTIFIER.name()));
    }
}

