/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.groupwindow.WindowProperty;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.window.WindowAggOperatorBuilder;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAggOperator;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceSharedAssigner;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-window-aggregate", version=1, consumedOptions={"table.local-time-zone"}, producedTransformations={"window-aggregate"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecWindowAggregate
extends StreamExecWindowAggregateBase {
    public static final String WINDOW_AGGREGATE_TRANSFORMATION = "window-aggregate";
    private static final long WINDOW_AGG_MEMORY_RATIO = 100L;
    public static final String FIELD_NAME_WINDOWING = "windowing";
    public static final String FIELD_NAME_NAMED_WINDOW_PROPERTIES = "namedWindowProperties";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="windowing")
    private final WindowingStrategy windowing;
    @JsonProperty(value="namedWindowProperties")
    private final NamedWindowProperty[] namedWindowProperties;
    @JsonProperty(value="needRetraction")
    private final boolean needRetraction;

    public StreamExecWindowAggregate(ReadableConfig tableConfig, int[] grouping, AggregateCall[] aggCalls, WindowingStrategy windowing, NamedWindowProperty[] namedWindowProperties, Boolean needRetraction, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecWindowAggregate.class), ExecNodeContext.newPersistedConfig(StreamExecWindowAggregate.class, tableConfig), grouping, aggCalls, windowing, namedWindowProperties, needRetraction, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecWindowAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="windowing") WindowingStrategy windowing, @JsonProperty(value="namedWindowProperties") NamedWindowProperty[] namedWindowProperties, @Nullable @JsonProperty(value="needRetraction") Boolean needRetraction, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.windowing = (WindowingStrategy)Preconditions.checkNotNull((Object)windowing);
        this.namedWindowProperties = (NamedWindowProperty[])Preconditions.checkNotNull((Object)namedWindowProperties);
        this.needRetraction = Optional.ofNullable(needRetraction).orElse(false);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone((LogicalType)this.windowing.getTimeAttributeType(), (ZoneId)TableConfigUtils.getLocalTimeZone(config));
        WindowAssigner windowAssigner = this.createWindowAssigner(this.windowing, shiftTimeZone);
        AggregateInfoList aggInfoList = AggregateUtil.deriveStreamWindowAggregateInfoList(planner.getTypeFactory(), inputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.needRetraction, this.windowing.getWindow(), true);
        GeneratedNamespaceAggsHandleFunction<?> generatedAggsHandler = this.createAggsHandler(windowAssigner, aggInfoList, config, planner.getFlinkContext().getClassLoader(), planner.createRelBuilder(), inputRowType.getChildren(), shiftTimeZone);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), this.grouping, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        LogicalType[] accTypes = this.convertToLogicalTypes(aggInfoList.getAccTypes());
        WindowAggOperator windowOperator = WindowAggOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)new RowDataSerializer(inputRowType)).shiftTimeZone(shiftTimeZone).keySerializer((PagedTypeSerializer)selector.getProducedType().toSerializer()).assigner(windowAssigner).countStarIndex(aggInfoList.getIndexOfCountStar()).aggregate(generatedAggsHandler, (AbstractRowDataSerializer)new RowDataSerializer(accTypes)).build();
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(WINDOW_AGGREGATE_TRANSFORMATION, config), SimpleOperatorFactory.of((StreamOperator)windowOperator), InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), 100L, false);
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }

    private GeneratedNamespaceAggsHandleFunction<?> createAggsHandler(WindowAssigner windowAssigner, AggregateInfoList aggInfoList, ExecNodeConfig config, ClassLoader classLoader, RelBuilder relBuilder, List<LogicalType> fieldTypes, ZoneId shiftTimeZone) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(new CodeGeneratorContext(config, classLoader), relBuilder, JavaScalaConversionUtil.toScala(fieldTypes), false).needAccumulate();
        if (windowAssigner instanceof SliceSharedAssigner || !this.isAlignedWindow(this.windowing.getWindow())) {
            generator.needMerge(0, false, null);
        }
        if (this.needRetraction) {
            generator.needRetract();
        }
        List windowProperties = Arrays.asList(Arrays.stream(this.namedWindowProperties).map(NamedWindowProperty::getProperty).toArray(WindowProperty[]::new));
        Class windowClass = this.isAlignedWindow(this.windowing.getWindow()) ? Long.class : TimeWindow.class;
        return generator.generateNamespaceAggsHandler("WindowAggsHandler", aggInfoList, JavaScalaConversionUtil.toScala(windowProperties), windowAssigner, windowClass, shiftTimeZone);
    }
}

