/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRule;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0001\u0003\u0003\u0003\u0019\"A\r'pO&\u001c\u0017\r\\\"peJ,G.\u0019;f)>Tu.\u001b8Ge>lw)\u001a8fe\u0006dG+Z7q_J\fG\u000eV1cY\u0016\u0014V\u000f\\3\u000b\u0005\r!\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000b\u0019\tQA];mKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005-bunZ5dC2\u001cuN\u001d:fY\u0006$X\rV8K_&tgI]8n)\u0016l\u0007o\u001c:bYR\u000b'\r\\3Sk2,\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u000f=\u0004XM]1oIB\u00111dH\u0007\u00029)\u0011q!\b\u0006\u0003=9\tqaY1mG&$X-\u0003\u0002!9\t\t\"+\u001a7PaR\u0014V\u000f\\3Pa\u0016\u0014\u0018M\u001c3\t\u0011\t\u0002!\u0011!Q\u0001\n\r\n1\u0002Z3tGJL\u0007\u000f^5p]B\u0011A%\f\b\u0003K-\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\n\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051J\u0003\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\bF\u00024iU\u0002\"!\u0006\u0001\t\u000be\u0001\u0004\u0019\u0001\u000e\t\u000b\t\u0002\u0004\u0019A\u0012\t\u000b]\u0002A\u0011\u0003\u001d\u0002;\u0015DHO]1diJKw\r\u001b;Fm\u0016tG\u000fV5nK&s\u0007/\u001e;SK\u001a$2!O\"L!\rQ4(P\u0007\u0002S%\u0011A(\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y\nU\"A \u000b\u0005\u0001k\u0012a\u0001:fq&\u0011!i\u0010\u0002\b%\u0016Dhj\u001c3f\u0011\u0015!e\u00071\u0001F\u0003%aWM\u001a;J]B,H\u000f\u0005\u0002G\u00136\tqI\u0003\u0002I;\u0005\u0019!/\u001a7\n\u0005);%a\u0002*fY:{G-\u001a\u0005\u0006\u0019Z\u0002\r!R\u0001\u000be&<\u0007\u000e^%oaV$\b\"\u0002(\u0001\t#y\u0015aG3yiJ\f7\r^*oCB\u001c\bn\u001c;US6,\u0017J\u001c9viJ+g\rF\u0002Q)V\u00032AO\u001eR!\tq$+\u0003\u0002T\u007f\tY!+\u001a=J]B,HOU3g\u0011\u0015!U\n1\u0001F\u0011\u00151V\n1\u0001X\u0003!\u0019h.\u00199tQ>$\bC\u0001-[\u001b\u0005I&BA\u0002H\u0013\tY\u0016LA\bM_\u001eL7-\u00197T]\u0006\u00048\u000f[8u\u0011\u0015i\u0006\u0001\"\u0011_\u0003\u001dyg.T1uG\"$\"a\u00182\u0011\u0005i\u0002\u0017BA1*\u0005\u0011)f.\u001b;\t\u000b\rd\u0006\u0019\u00013\u0002\t\r\fG\u000e\u001c\t\u00037\u0015L!A\u001a\u000f\u0003\u001dI+Gn\u00149u%VdWmQ1mY\")\u0001\u000e\u0001C\u0005S\u0006yQ\r\u001f;sC\u000e$(j\\5o\u0017\u0016L8\u000f\u0006\u0002kmB!!h[7n\u0013\ta\u0017F\u0001\u0004UkBdWM\r\t\u0004]NldBA8r\u001d\t1\u0003/C\u0001+\u0013\t\u0011\u0018&A\u0004qC\u000e\\\u0017mZ3\n\u0005Q,(aA*fc*\u0011!/\u000b\u0005\u0006o\u001e\u0004\r\u0001_\u0001\u000bC\u000e$X/\u00197K_&t\u0007C\u0001-z\u0013\tQ\u0018LA\u0006M_\u001eL7-\u00197K_&t\u0007\"\u0002?\u0001\t\u0013i\u0018AG5t%><H+[7f)\u0016l\u0007o\u001c:bYR\u000b'\r\\3K_&tGc\u0001@\u0002\u0004A\u0011!h`\u0005\u0004\u0003\u0003I#a\u0002\"p_2,\u0017M\u001c\u0005\u0006-n\u0004\ra\u0016")
public abstract class LogicalCorrelateToJoinFromGeneralTemporalTableRule
extends LogicalCorrelateToJoinFromTemporalTableRule {
    public Option<RexNode> extractRightEventTimeInputRef(RelNode leftInput, RelNode rightInput) {
        None$ none$;
        Buffer rightFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rightInput.getRowType().getFieldList()).asScala();
        Buffer timeAttributeFields = (Buffer)rightFields.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogicalCorrelateToJoinFromGeneralTemporalTableRule.$anonfun$extractRightEventTimeInputRef$1(f)));
        if (timeAttributeFields.length() == 1) {
            int timeColIndex = leftInput.getRowType().getFieldCount() + rightFields.indexOf(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(timeAttributeFields).get(0));
            RelDataType timeColDataType = ((RelDataTypeField)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(timeAttributeFields).get(0)).getType();
            RexBuilder rexBuilder = rightInput.getCluster().getRexBuilder();
            none$ = new Some((Object)rexBuilder.makeInputRef(timeColDataType, timeColIndex));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<RexInputRef> extractSnapshotTimeInputRef(RelNode leftInput, LogicalSnapshot snapshot) {
        None$ none$;
        RelDataTypeField periodField;
        RelDataType leftRowType = leftInput.getRowType();
        List<RelDataTypeField> leftFields = leftRowType.getFieldList();
        if (leftFields.contains(periodField = ((RexFieldAccess)snapshot.getPeriod()).getField())) {
            int index = leftRowType.getFieldList().indexOf(periodField);
            none$ = new Some((Object)RexInputRef.of(index, leftRowType));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode relNode;
        RexNode rexNode;
        RelNode rewriteJoin;
        LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
        Object leftInput = call.rel(1);
        RexNode filterCondition = this.getFilterCondition(call);
        LogicalSnapshot snapshot = this.getLogicalSnapshot(call);
        RelDataType leftRowType = leftInput.getRowType();
        RexNode joinCondition = this.decorrelate(filterCondition, leftRowType, correlate.getCorrelationId());
        this.validateSnapshotInCorrelate(snapshot, correlate);
        RexBuilder rexBuilder = correlate.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)leftInput);
        relBuilder.push(snapshot);
        LogicalJoin nonPushedJoin = (LogicalJoin)relBuilder.join(correlate.getJoinType(), joinCondition).build();
        RelNode relNode2 = rewriteJoin = RelOptUtil.pushDownJoinConditions((Join)nonPushedJoin, relBuilder);
        LogicalJoin logicalJoin = relNode2 instanceof LogicalJoin ? (LogicalJoin)rewriteJoin : (LogicalJoin)rewriteJoin.getInput(0);
        LogicalJoin actualJoin = logicalJoin;
        Tuple2<Seq<RexNode>, Seq<RexNode>> tuple2 = this.extractJoinKeys(actualJoin);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq leftJoinKey = (Seq)tuple2._1();
        Seq rightJoinKey = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftJoinKey, (Object)rightJoinKey);
        Tuple2 tuple23 = tuple22;
        Seq leftJoinKey2 = (Seq)tuple23._1();
        Seq rightJoinKey2 = (Seq)tuple23._2();
        RexInputRef snapshotTimeInputRef = (RexInputRef)this.extractSnapshotTimeInputRef(actualJoin.getLeft(), snapshot).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ValidationException("Temporal Table Join requires time attribute in the left table, but no time attribute found.");
        });
        if (this.isRowTimeTemporalTableJoin(snapshot)) {
            Option<RexNode> rightTimeInputRef = this.extractRightEventTimeInputRef(actualJoin.getLeft(), actualJoin.getRight());
            if (rightTimeInputRef.isEmpty() || !FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(((RexNode)rightTimeInputRef.get()).getType())) {
                throw new ValidationException(new StringBuilder(139).append("Event-Time Temporal Table Join requires both").append(" primary key and row time attribute in versioned table,").append(" but no row time attribute can be found.").toString());
            }
            SqlTypeName sqlTypeName = snapshotTimeInputRef.getType().getSqlTypeName();
            SqlTypeName sqlTypeName2 = ((RexNode)rightTimeInputRef.get()).getType().getSqlTypeName();
            if (sqlTypeName == null ? sqlTypeName2 != null : !((Object)((Object)sqlTypeName)).equals((Object)sqlTypeName2)) {
                throw new ValidationException(String.format("Event-Time Temporal Table Join requires same rowtime type in left table and versioned table, but the rowtime types are %s and %s.", ((Object)snapshotTimeInputRef.getType()).toString(), ((Object)((RexNode)rightTimeInputRef.get()).getType()).toString()));
            }
            rexNode = TemporalJoinUtil$.MODULE$.makeInitialRowTimeTemporalTableJoinCondCall(rexBuilder, snapshotTimeInputRef, (RexNode)rightTimeInputRef.get(), (Seq<RexNode>)leftJoinKey2, (Seq<RexNode>)rightJoinKey2);
        } else {
            rexNode = TemporalJoinUtil$.MODULE$.makeInitialProcTimeTemporalTableJoinConCall(rexBuilder, snapshotTimeInputRef, (Seq<RexNode>)leftJoinKey2, (Seq<RexNode>)rightJoinKey2);
        }
        RexNode temporalCondition = rexNode;
        RelBuilder builder = call.builder();
        RexNode condition = builder.and(actualJoin.getCondition(), temporalCondition);
        LogicalJoin joinWithTemporalCondition = actualJoin.copy(actualJoin.getTraitSet(), condition, actualJoin.getLeft(), actualJoin.getRight(), actualJoin.getJoinType(), actualJoin.isSemiJoinDone());
        LogicalJoin logicalJoin2 = actualJoin;
        RelNode relNode3 = rewriteJoin;
        if (logicalJoin2 == null ? relNode3 != null : !((Object)logicalJoin2).equals(relNode3)) {
            rewriteJoin.replaceInput(0, joinWithTemporalCondition);
            relNode = rewriteJoin;
        } else {
            relNode = joinWithTemporalCondition;
        }
        LogicalJoin temporalJoin = relNode;
        call.transformTo(temporalJoin);
    }

    private Tuple2<Seq<RexNode>, Seq<RexNode>> extractJoinKeys(LogicalJoin actualJoin) {
        JoinInfo joinInfo = actualJoin.analyzeCondition();
        RelNode leftInput = actualJoin.getInput(0);
        RelNode rightInput = actualJoin.getInput(1);
        RexBuilder rexBuilder = actualJoin.getCluster().getRexBuilder();
        Buffer leftJoinKey = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((List)joinInfo.leftKeys).map((Function1 & Serializable & scala.Serializable)i -> rexBuilder.makeInputRef(leftInput, Predef$.MODULE$.Integer2int(i)), Buffer$.MODULE$.canBuildFrom());
        int leftFieldCnt = leftInput.getRowType().getFieldCount();
        Buffer rightJoinKey = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((List)joinInfo.rightKeys).map((Function1 & Serializable & scala.Serializable)i -> {
            RelDataType rightKeyType = rightInput.getRowType().getFieldList().get(Predef$.MODULE$.Integer2int(i)).getType();
            return rexBuilder.makeInputRef(rightKeyType, leftFieldCnt + Predef$.MODULE$.Integer2int(i));
        }, Buffer$.MODULE$.canBuildFrom());
        if (leftJoinKey.isEmpty() || rightJoinKey.isEmpty()) {
            throw new ValidationException("Currently the join key in Temporal Table Join can not be empty.");
        }
        return new Tuple2((Object)leftJoinKey, (Object)rightJoinKey);
    }

    private boolean isRowTimeTemporalTableJoin(LogicalSnapshot snapshot) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType = snapshot.getPeriod().getType();
        boolean bl = relDataType instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType).isEventTime();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$extractRightEventTimeInputRef$1(RelDataTypeField f) {
        return f.getType() instanceof TimeIndicatorRelDataType && ((TimeIndicatorRelDataType)f.getType()).isEventTime();
    }

    public LogicalCorrelateToJoinFromGeneralTemporalTableRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }
}

