/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.typeutils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.flink.annotation.Internal;
import org.apache.flink.calcite.shaded.com.google.common.collect.BoundType;
import org.apache.flink.table.api.JsonExistsOnError;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.api.JsonQueryOnEmptyOrError;
import org.apache.flink.table.api.JsonQueryWrapper;
import org.apache.flink.table.api.JsonValueOnEmptyOrError;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class SymbolUtil {
    private static final Map<Class<?>, String> calciteToSymbolKind = new HashMap();
    private static final Map<SerializableSymbol, Enum<?>> serializableToCalcite = new HashMap();
    private static final Map<Enum<?>, SerializableSymbol> calciteToSerializable = new HashMap();
    private static final Map<Enum<?>, Enum<?>> calciteToCommon = new HashMap();
    private static final Map<Enum<?>, Enum<?>> commonToCalcite = new HashMap();
    private static final Map<Enum<?>, Enum<?>> calciteToInternalCommon = new HashMap();
    private static final Map<Enum<?>, Enum<?>> internalCommonToCalcite = new HashMap();

    public static Enum<?> commonToCalcite(Enum<?> commonSymbol) {
        SymbolUtil.checkCommonSymbol(commonSymbol);
        Enum<?> calciteSymbol = commonToCalcite.get(commonSymbol);
        if (calciteSymbol == null && (calciteSymbol = internalCommonToCalcite.get(commonSymbol)) == null) {
            throw new UnsupportedOperationException(String.format("Cannot map '%s' to an internal symbol.", commonSymbol));
        }
        return calciteSymbol;
    }

    public static Enum<?> calciteToCommon(Enum<?> calciteSymbol, boolean preferInternal) {
        Enum<?> internalCommonSymbol;
        SymbolUtil.checkCalciteSymbol(calciteSymbol);
        Enum<?> enum_ = internalCommonSymbol = preferInternal ? calciteToInternalCommon.get(calciteSymbol) : null;
        if (internalCommonSymbol == null && (internalCommonSymbol = calciteToCommon.get(calciteSymbol)) == null) {
            return calciteSymbol;
        }
        return internalCommonSymbol;
    }

    public static SerializableSymbol calciteToSerializable(Enum<?> calciteSymbol) {
        SerializableSymbol serializableSymbol = calciteToSerializable.get(calciteSymbol);
        if (serializableSymbol == null) {
            throw new TableException(String.format("Symbol class '%s' has no serializable representation.", calciteSymbol.getClass().getName()));
        }
        return serializableSymbol;
    }

    public static Enum<?> serializableToCalcite(SerializableSymbol serializableSymbol) {
        Enum<?> calciteSymbol = serializableToCalcite.get(serializableSymbol);
        if (calciteSymbol == null) {
            throw new TableException(String.format("Cannot find a corresponding symbol class for '%s'.", serializableSymbol));
        }
        return calciteSymbol;
    }

    public static <T extends Enum<T>> T serializableToCalcite(Class<T> calciteSymbolClass, String value) {
        String symbolKind = calciteToSymbolKind.get(calciteSymbolClass);
        if (symbolKind == null) {
            throw new TableException(String.format("Cannot find a corresponding symbol kind for class '%s'.", calciteSymbolClass.getName()));
        }
        return (T)serializableToCalcite.get(SerializableSymbol.of(symbolKind, value));
    }

    private static void addSymbolMapping(@Nullable TableSymbol commonSymbol, @Nullable Enum<?> commonInternalSymbol, Enum<?> calciteSymbol, String serializableKind, String serializableValue) {
        Preconditions.checkNotNull(calciteSymbol, (String)"Calcite symbol must not be null.");
        Preconditions.checkNotNull((Object)serializableKind, (String)"Serializable kind must not be null.");
        Preconditions.checkNotNull((Object)serializableValue, (String)"Serializable value must not be null.");
        SerializableSymbol serializableSymbol = SerializableSymbol.of(serializableKind, serializableValue);
        SymbolUtil.checkCalciteSymbol(calciteSymbol);
        Class<?> calciteSymbolClass = calciteSymbol.getDeclaringClass();
        if (calciteToSymbolKind.containsKey(calciteSymbolClass)) {
            Preconditions.checkArgument((boolean)calciteToSymbolKind.get(calciteSymbolClass).equals(serializableKind), (Object)"All Calcite symbols should map to the same kind.");
        } else {
            calciteToSymbolKind.put(calciteSymbolClass, serializableKind);
        }
        serializableToCalcite.put(serializableSymbol, calciteSymbol);
        calciteToSerializable.put(calciteSymbol, serializableSymbol);
        if (commonSymbol != null) {
            Enum commonSymbolEnum = (Enum)commonSymbol;
            SymbolUtil.checkCommonSymbol(commonSymbolEnum);
            calciteToCommon.put(calciteSymbol, commonSymbolEnum);
            commonToCalcite.put(commonSymbolEnum, calciteSymbol);
        }
        if (commonInternalSymbol != null) {
            SymbolUtil.checkCommonSymbol(commonInternalSymbol);
            calciteToInternalCommon.put(calciteSymbol, commonInternalSymbol);
            internalCommonToCalcite.put(commonInternalSymbol, calciteSymbol);
        }
    }

    private static void checkCalciteSymbol(Enum<?> calciteSymbol) {
        String className = calciteSymbol.getClass().getName();
        Preconditions.checkArgument((className.startsWith("org.apache.calcite.") || className.startsWith("org.apache.flink.calcite.shaded.com.google.common.collect.") ? 1 : 0) != 0, (String)"Class '%s' is not a Calcite symbol.", (Object[])new Object[]{calciteSymbol});
    }

    private static void checkCommonSymbol(Enum<?> commonInternalSymbol) {
        Preconditions.checkArgument((boolean)commonInternalSymbol.getClass().getName().startsWith("org.apache.flink.table."), (String)"Class '%s' is not a Flink symbol.", (Object[])new Object[]{commonInternalSymbol});
    }

    private SymbolUtil() {
    }

    static {
        SymbolUtil.addSymbolMapping(null, null, SqlTrimFunction.Flag.BOTH, "TRIM", "BOTH");
        SymbolUtil.addSymbolMapping(null, null, SqlTrimFunction.Flag.LEADING, "TRIM", "LEADING");
        SymbolUtil.addSymbolMapping(null, null, SqlTrimFunction.Flag.TRAILING, "TRIM", "TRAILING");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonExistsOnError.TRUE, null, SqlJsonExistsErrorBehavior.TRUE, "JSON_EXISTS_ON_ERROR", "TRUE");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonExistsOnError.FALSE, null, SqlJsonExistsErrorBehavior.FALSE, "JSON_EXISTS_ON_ERROR", "FALSE");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonExistsOnError.UNKNOWN, null, SqlJsonExistsErrorBehavior.UNKNOWN, "JSON_EXISTS_ON_ERROR", "UNKNOWN");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonExistsOnError.ERROR, null, SqlJsonExistsErrorBehavior.ERROR, "JSON_EXISTS_ON_ERROR", "ERROR");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonValueOnEmptyOrError.ERROR, null, SqlJsonValueEmptyOrErrorBehavior.ERROR, "JSON_VALUE_ON_EMPTY_OR_ERROR", "ERROR");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonValueOnEmptyOrError.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, "JSON_VALUE_ON_EMPTY_OR_ERROR", "NULL");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonValueOnEmptyOrError.DEFAULT, null, SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "JSON_VALUE_ON_EMPTY_OR_ERROR", "DEFAULT");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonQueryWrapper.WITHOUT_ARRAY, null, SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, "JSON_QUERY_WRAPPER", "WITHOUT_ARRAY");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonQueryWrapper.CONDITIONAL_ARRAY, null, SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, "JSON_QUERY_WRAPPER", "CONDITIONAL_ARRAY");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonQueryWrapper.UNCONDITIONAL_ARRAY, null, SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, "JSON_QUERY_WRAPPER", "WITH_UNCONDITIONAL_ARRAY");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonQueryOnEmptyOrError.ERROR, null, SqlJsonQueryEmptyOrErrorBehavior.ERROR, "JSON_QUERY_ON_EMPTY_OR_ERROR", "ERROR");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonQueryOnEmptyOrError.NULL, null, SqlJsonQueryEmptyOrErrorBehavior.NULL, "JSON_QUERY_ON_EMPTY_OR_ERROR", "NULL");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonQueryOnEmptyOrError.EMPTY_ARRAY, null, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, "JSON_QUERY_ON_EMPTY_OR_ERROR", "EMPTY_ARRAY");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonQueryOnEmptyOrError.EMPTY_OBJECT, null, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, "JSON_QUERY_ON_EMPTY_OR_ERROR", "EMPTY_OBJECT");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonOnNull.NULL, null, SqlJsonConstructorNullClause.NULL_ON_NULL, "JSON_ON_NULL", "NULL");
        SymbolUtil.addSymbolMapping((TableSymbol)JsonOnNull.ABSENT, null, SqlJsonConstructorNullClause.ABSENT_ON_NULL, "JSON_ON_NULL", "ABSENT");
        SymbolUtil.addSymbolMapping(null, null, SqlJsonEmptyOrError.EMPTY, "JSON_EMPTY_OR_ERROR", "EMPTY");
        SymbolUtil.addSymbolMapping(null, null, SqlJsonEmptyOrError.ERROR, "JSON_EMPTY_OR_ERROR", "ERROR");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.MILLENNIUM, DateTimeUtils.TimeUnitRange.MILLENNIUM, TimeUnitRange.MILLENNIUM, "TIME_UNIT_RANGE", "MILLENNIUM");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.CENTURY, DateTimeUtils.TimeUnitRange.CENTURY, TimeUnitRange.CENTURY, "TIME_UNIT_RANGE", "CENTURY");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.DECADE, DateTimeUtils.TimeUnitRange.DECADE, TimeUnitRange.DECADE, "TIME_UNIT_RANGE", "DECADE");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.YEAR, DateTimeUtils.TimeUnitRange.YEAR, TimeUnitRange.YEAR, "TIME_UNIT_RANGE", "YEAR");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.YEAR_TO_MONTH, DateTimeUtils.TimeUnitRange.YEAR_TO_MONTH, TimeUnitRange.YEAR_TO_MONTH, "TIME_UNIT_RANGE", "YEAR_TO_MONTH");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.MONTH, DateTimeUtils.TimeUnitRange.MONTH, TimeUnitRange.MONTH, "TIME_UNIT_RANGE", "MONTH");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.DAY, DateTimeUtils.TimeUnitRange.DAY, TimeUnitRange.DAY, "TIME_UNIT_RANGE", "DAY");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.DAY_TO_HOUR, DateTimeUtils.TimeUnitRange.DAY_TO_HOUR, TimeUnitRange.DAY_TO_HOUR, "TIME_UNIT_RANGE", "DAY_TO_HOUR");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.DAY_TO_MINUTE, DateTimeUtils.TimeUnitRange.DAY_TO_MINUTE, TimeUnitRange.DAY_TO_MINUTE, "TIME_UNIT_RANGE", "DAY_TO_MINUTE");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.DAY_TO_SECOND, DateTimeUtils.TimeUnitRange.DAY_TO_SECOND, TimeUnitRange.DAY_TO_SECOND, "TIME_UNIT_RANGE", "DAY_TO_SECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.HOUR, DateTimeUtils.TimeUnitRange.HOUR, TimeUnitRange.HOUR, "TIME_UNIT_RANGE", "HOUR");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.HOUR_TO_MINUTE, DateTimeUtils.TimeUnitRange.HOUR_TO_MINUTE, TimeUnitRange.HOUR_TO_MINUTE, "TIME_UNIT_RANGE", "HOUR_TO_MINUTE");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.HOUR_TO_SECOND, DateTimeUtils.TimeUnitRange.HOUR_TO_SECOND, TimeUnitRange.HOUR_TO_SECOND, "TIME_UNIT_RANGE", "HOUR_TO_SECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.MINUTE, DateTimeUtils.TimeUnitRange.MINUTE, TimeUnitRange.MINUTE, "TIME_UNIT_RANGE", "MINUTE");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.MINUTE_TO_SECOND, DateTimeUtils.TimeUnitRange.MINUTE_TO_SECOND, TimeUnitRange.MINUTE_TO_SECOND, "TIME_UNIT_RANGE", "MINUTE_TO_SECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.SECOND, DateTimeUtils.TimeUnitRange.SECOND, TimeUnitRange.SECOND, "TIME_UNIT_RANGE", "SECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.MILLISECOND, DateTimeUtils.TimeUnitRange.MILLISECOND, TimeUnitRange.MILLISECOND, "TIME_UNIT_RANGE", "MILLISECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.MICROSECOND, DateTimeUtils.TimeUnitRange.MICROSECOND, TimeUnitRange.MICROSECOND, "TIME_UNIT_RANGE", "MICROSECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.NANOSECOND, DateTimeUtils.TimeUnitRange.NANOSECOND, TimeUnitRange.NANOSECOND, "TIME_UNIT_RANGE", "NANOSECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.EPOCH, DateTimeUtils.TimeUnitRange.EPOCH, TimeUnitRange.EPOCH, "TIME_UNIT_RANGE", "EPOCH");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.QUARTER, DateTimeUtils.TimeUnitRange.QUARTER, TimeUnitRange.QUARTER, "TIME_UNIT_RANGE", "QUARTER");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.ISOYEAR, TimeUnitRange.ISOYEAR, "TIME_UNIT_RANGE", "ISOYEAR");
        SymbolUtil.addSymbolMapping((TableSymbol)TimeIntervalUnit.WEEK, DateTimeUtils.TimeUnitRange.WEEK, TimeUnitRange.WEEK, "TIME_UNIT_RANGE", "WEEK");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.MILLISECOND, TimeUnitRange.MILLISECOND, "TIME_UNIT_RANGE", "MILLISECOND");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.MICROSECOND, TimeUnitRange.MICROSECOND, "TIME_UNIT_RANGE", "MICROSECOND");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.NANOSECOND, TimeUnitRange.NANOSECOND, "TIME_UNIT_RANGE", "NANOSECOND");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.DOW, TimeUnitRange.DOW, "TIME_UNIT_RANGE", "DOW");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.ISODOW, TimeUnitRange.ISODOW, "TIME_UNIT_RANGE", "ISODOW");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.DOY, TimeUnitRange.DOY, "TIME_UNIT_RANGE", "DOY");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.EPOCH, TimeUnitRange.EPOCH, "TIME_UNIT_RANGE", "EPOCH");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.DECADE, TimeUnitRange.DECADE, "TIME_UNIT_RANGE", "DECADE");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.CENTURY, TimeUnitRange.CENTURY, "TIME_UNIT_RANGE", "CENTURY");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnitRange.MILLENNIUM, TimeUnitRange.MILLENNIUM, "TIME_UNIT_RANGE", "MILLENNIUM");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.YEAR, DateTimeUtils.TimeUnit.YEAR, TimeUnit.YEAR, "TIME_UNIT", "YEAR");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.MONTH, DateTimeUtils.TimeUnit.MONTH, TimeUnit.MONTH, "TIME_UNIT", "MONTH");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.DAY, DateTimeUtils.TimeUnit.DAY, TimeUnit.DAY, "TIME_UNIT", "DAY");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.HOUR, DateTimeUtils.TimeUnit.HOUR, TimeUnit.HOUR, "TIME_UNIT", "HOUR");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.MINUTE, DateTimeUtils.TimeUnit.MINUTE, TimeUnit.MINUTE, "TIME_UNIT", "MINUTE");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.SECOND, DateTimeUtils.TimeUnit.SECOND, TimeUnit.SECOND, "TIME_UNIT", "SECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.QUARTER, DateTimeUtils.TimeUnit.QUARTER, TimeUnit.QUARTER, "TIME_UNIT", "QUARTER");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.WEEK, DateTimeUtils.TimeUnit.WEEK, TimeUnit.WEEK, "TIME_UNIT", "WEEK");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.MILLISECOND, DateTimeUtils.TimeUnit.MILLISECOND, TimeUnit.MILLISECOND, "TIME_UNIT", "MILLISECOND");
        SymbolUtil.addSymbolMapping((TableSymbol)TimePointUnit.MICROSECOND, DateTimeUtils.TimeUnit.MICROSECOND, TimeUnit.MICROSECOND, "TIME_UNIT", "MICROSECOND");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnit.DOW, TimeUnit.DOW, "TIME_UNIT", "DOW");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnit.DOY, TimeUnit.DOY, "TIME_UNIT", "DOY");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnit.EPOCH, TimeUnit.EPOCH, "TIME_UNIT", "EPOCH");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnit.DECADE, TimeUnit.DECADE, "TIME_UNIT", "DECADE");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnit.CENTURY, TimeUnit.CENTURY, "TIME_UNIT", "CENTURY");
        SymbolUtil.addSymbolMapping(null, DateTimeUtils.TimeUnit.MILLENNIUM, TimeUnit.MILLENNIUM, "TIME_UNIT", "MILLENNIUM");
        SymbolUtil.addSymbolMapping(null, null, SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW, "MATCH_RECOGNIZE_AFTER_OPTION", "SKIP_TO_NEXT_ROW");
        SymbolUtil.addSymbolMapping(null, null, SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW, "MATCH_RECOGNIZE_AFTER_OPTION", "SKIP_PAST_LAST_ROW");
        SymbolUtil.addSymbolMapping(null, null, SqlSyntax.FUNCTION, "SYNTAX", "FUNCTION");
        SymbolUtil.addSymbolMapping(null, null, SqlSyntax.FUNCTION_STAR, "SYNTAX", "FUNCTION_STAR");
        SymbolUtil.addSymbolMapping(null, null, SqlSyntax.BINARY, "SYNTAX", "BINARY");
        SymbolUtil.addSymbolMapping(null, null, SqlSyntax.PREFIX, "SYNTAX", "PREFIX");
        SymbolUtil.addSymbolMapping(null, null, SqlSyntax.POSTFIX, "SYNTAX", "POSTFIX");
        SymbolUtil.addSymbolMapping(null, null, SqlSyntax.SPECIAL, "SYNTAX", "SPECIAL");
        SymbolUtil.addSymbolMapping(null, null, SqlSyntax.FUNCTION_ID, "SYNTAX", "FUNCTION_ID");
        SymbolUtil.addSymbolMapping(null, null, SqlSyntax.INTERNAL, "SYNTAX", "INTERNAL");
        SymbolUtil.addSymbolMapping(null, null, BoundType.OPEN, "BOUND", "OPEN");
        SymbolUtil.addSymbolMapping(null, null, BoundType.CLOSED, "BOUND", "CLOSED");
        SymbolUtil.addSymbolMapping(null, null, RexUnknownAs.TRUE, "UNKNOWN_AS", "TRUE");
        SymbolUtil.addSymbolMapping(null, null, RexUnknownAs.FALSE, "UNKNOWN_AS", "FALSE");
        SymbolUtil.addSymbolMapping(null, null, RexUnknownAs.UNKNOWN, "UNKNOWN_AS", "UNKNOWN");
    }

    public static class SerializableSymbol {
        private final String kind;
        private final String value;

        private SerializableSymbol(String kind, String value) {
            this.kind = kind;
            this.value = value;
        }

        public static SerializableSymbol of(String kind, String value) {
            return new SerializableSymbol(kind, value);
        }

        public String getKind() {
            return this.kind;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableSymbol that = (SerializableSymbol)o;
            return this.kind.equals(that.kind) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.kind, this.value);
        }

        public String toString() {
            return this.kind + '.' + this.value;
        }
    }
}

