/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.distcp;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.examples.java.distcp.FileCopyTask;
import org.apache.flink.examples.java.distcp.FileCopyTaskInputSplit;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCopyTaskInputFormat
implements InputFormat<FileCopyTask, FileCopyTaskInputSplit> {
    private static final long serialVersionUID = -644394866425221151L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileCopyTaskInputFormat.class);
    private final List<FileCopyTask> tasks;
    private FileCopyTaskInputSplit curInputSplit = null;

    public FileCopyTaskInputFormat(List<FileCopyTask> tasks) {
        this.tasks = tasks;
    }

    public void configure(Configuration parameters) {
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
        return null;
    }

    public FileCopyTaskInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        FileCopyTaskInputSplit[] splits = new FileCopyTaskInputSplit[this.tasks.size()];
        int i = 0;
        for (FileCopyTask t : this.tasks) {
            splits[i] = new FileCopyTaskInputSplit(t, i);
            ++i;
        }
        return splits;
    }

    public InputSplitAssigner getInputSplitAssigner(FileCopyTaskInputSplit[] inputSplits) {
        return new FileCopyTaskAssigner(inputSplits);
    }

    public void open(FileCopyTaskInputSplit split) throws IOException {
        this.curInputSplit = split;
    }

    public boolean reachedEnd() throws IOException {
        return this.curInputSplit == null;
    }

    public FileCopyTask nextRecord(FileCopyTask reuse) throws IOException {
        FileCopyTask toReturn = this.curInputSplit.getTask();
        this.curInputSplit = null;
        return toReturn;
    }

    public void close() throws IOException {
    }

    private class FileCopyTaskAssigner
    implements InputSplitAssigner {
        private Queue<FileCopyTaskInputSplit> splits;

        public FileCopyTaskAssigner(FileCopyTaskInputSplit[] inputSplits) {
            this.splits = new LinkedList<FileCopyTaskInputSplit>(Arrays.asList(inputSplits));
        }

        public InputSplit getNextInputSplit(String host, int taskId) {
            LOGGER.info("Getting copy task for task: " + taskId);
            return this.splits.poll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnInputSplit(List<InputSplit> splits, int taskId) {
            Queue<FileCopyTaskInputSplit> queue = this.splits;
            synchronized (queue) {
                for (InputSplit split : splits) {
                    Preconditions.checkState((boolean)this.splits.add((FileCopyTaskInputSplit)split));
                }
            }
        }
    }
}

