/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.geode.cache.client.internal.locator.SerializationHelper;
import org.apache.geode.cache.client.internal.locator.ServerLocationResponse;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class GetAllServersResponse
extends ServerLocationResponse {
    private ArrayList<ServerLocation> servers;
    private boolean serversFound = false;

    public GetAllServersResponse() {
    }

    public GetAllServersResponse(ArrayList<ServerLocation> servers) {
        this.servers = servers;
        if (servers != null && !servers.isEmpty()) {
            this.serversFound = true;
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.servers = SerializationHelper.readServerLocationList(in);
        if (this.servers != null && !this.servers.isEmpty()) {
            this.serversFound = true;
        }
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        SerializationHelper.writeServerLocationList(this.servers, out);
    }

    public ArrayList<ServerLocation> getServers() {
        return this.servers;
    }

    public String toString() {
        return "GetAllServersResponse{servers=" + this.getServers() + "}";
    }

    public int getDSFID() {
        return -42;
    }

    @Override
    public boolean hasResult() {
        return this.serversFound;
    }
}

