/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelCriterion;
import org.apache.geode.LogWriter;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.metrics.internal.InternalDistributedSystemMetricsService;

public abstract class DistributedSystem
implements StatisticsFactory {
    @MakeNotStatic
    protected static volatile List<InternalDistributedSystem> existingSystems = Collections.emptyList();
    protected static final Object existingSystemsLock = new Object();
    public static final String PROPERTIES_FILE_PROPERTY = "gemfirePropertyFile";
    public static final String PROPERTIES_FILE_DEFAULT = "gemfire.properties";
    @Deprecated
    public static final String PROPERTY_FILE = DistributedSystem.getPropertiesFile();
    public static final String SECURITY_PROPERTIES_FILE_PROPERTY = "gemfireSecurityPropertyFile";
    public static final String SECURITY_PROPERTIES_FILE_DEFAULT = "gfsecurity.properties";
    @Deprecated
    public static final String SECURITY_PROPERTY_FILE = DistributedSystem.getSecurityPropertiesFile();

    @Deprecated
    public static DistributedSystem connect(Properties config) {
        return InternalDistributedSystem.connectInternal(config, null, new InternalDistributedSystemMetricsService.Builder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addSystem(InternalDistributedSystem newSystem) {
        Object object = existingSystemsLock;
        synchronized (object) {
            int size = existingSystems.size();
            if (size == 0) {
                existingSystems = Collections.singletonList(newSystem);
            } else {
                ArrayList<InternalDistributedSystem> l = new ArrayList<InternalDistributedSystem>(size + 1);
                l.addAll(existingSystems);
                l.add(0, newSystem);
                existingSystems = Collections.unmodifiableList(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeSystem(InternalDistributedSystem oldSystem) {
        Object object = existingSystemsLock;
        synchronized (object) {
            ArrayList<InternalDistributedSystem> listOfSystems = new ArrayList<InternalDistributedSystem>(existingSystems);
            boolean result = listOfSystems.remove(oldSystem);
            if (result) {
                int size = listOfSystems.size();
                existingSystems = size == 0 ? Collections.emptyList() : (size == 1 ? Collections.singletonList(listOfSystems.get(0)) : Collections.unmodifiableList(listOfSystems));
            }
        }
    }

    public static void setThreadsSocketPolicy(boolean conserveSockets) {
        if (conserveSockets) {
            ConnectionTable.threadWantsSharedResources();
        } else {
            ConnectionTable.threadWantsOwnResources();
        }
    }

    public static void releaseThreadsSockets() {
        ConnectionTable.releaseThreadsSockets();
    }

    protected static DistributedSystem getConnection(Properties config) {
        for (InternalDistributedSystem existingSystem : existingSystems) {
            if (!existingSystem.sameSystemAs(config)) continue;
            Assert.assertTrue(existingSystem.isConnected());
            return existingSystem;
        }
        return null;
    }

    protected static DistributedSystem connectForAdmin(Properties props) {
        DistributedSystem existing = DistributedSystem.getConnection(props);
        if (existing != null) {
            return existing;
        }
        props.setProperty("conserve-sockets", "true");
        return DistributedSystem.connect(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setEnableAdministrationOnly(boolean adminOnly) {
        Object object = existingSystemsLock;
        synchronized (object) {
            if (existingSystems != null && !existingSystems.isEmpty()) {
                throw new IllegalStateException(String.format("This VM already has one or more Distributed System connections %s", existingSystems));
            }
            ClusterDistributionManager.setIsDedicatedAdminVM(adminOnly);
        }
    }

    protected DistributedSystem() {
    }

    @Deprecated
    public abstract LogWriter getLogWriter();

    @Deprecated
    public abstract LogWriter getSecurityLogWriter();

    public abstract Properties getProperties();

    public abstract Properties getSecurityProperties();

    public abstract CancelCriterion getCancelCriterion();

    @Deprecated
    public abstract void disconnect();

    public abstract boolean isConnected();

    @Deprecated
    public abstract long getId();

    @Deprecated
    public abstract String getMemberId();

    public abstract DistributedMember getDistributedMember();

    public abstract Set<DistributedMember> getAllOtherMembers();

    public abstract Set<DistributedMember> getGroupMembers(String var1);

    public abstract Set<DistributedMember> findDistributedMembers(InetAddress var1);

    public abstract DistributedMember findDistributedMember(String var1);

    public abstract String getName();

    public static String getPropertiesFile() {
        return System.getProperty(PROPERTIES_FILE_PROPERTY, PROPERTIES_FILE_DEFAULT);
    }

    public static String getSecurityPropertiesFile() {
        return System.getProperty(SECURITY_PROPERTIES_FILE_PROPERTY, SECURITY_PROPERTIES_FILE_DEFAULT);
    }

    public static URL getPropertiesFileURL() {
        return DistributedSystem.getFileURL(DistributedSystem.getPropertiesFile());
    }

    @Deprecated
    public static URL getPropertyFileURL() {
        return DistributedSystem.getPropertiesFileURL();
    }

    public static URL getSecurityPropertiesFileURL() {
        return DistributedSystem.getFileURL(DistributedSystem.getSecurityPropertiesFile());
    }

    private static URL getFileURL(String fileName) {
        File file = new File(fileName).getAbsoluteFile();
        if (file.exists()) {
            try {
                return IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(file).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((file = new File(System.getProperty("user.home"), fileName)).exists()) {
            try {
                return IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(file).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return ClassPathLoader.getLatest().getResource(DistributedSystem.class, fileName);
    }

    public abstract boolean isReconnecting();

    public abstract boolean waitUntilReconnected(long var1, TimeUnit var3) throws InterruptedException;

    public abstract void stopReconnecting();

    public abstract DistributedSystem getReconnectedSystem();
}

