/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitioning;

import java.util.Arrays;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.PartitionUtils;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.transforms.Transforms;

public final class TruncatePartitioningDTO
implements Partitioning {
    private final int width;
    private final String[] fieldName;

    public static TruncatePartitioningDTO of(int width, String[] fieldName) {
        return new TruncatePartitioningDTO(width, fieldName);
    }

    private TruncatePartitioningDTO(int width, String[] fieldName) {
        this.width = width;
        this.fieldName = fieldName;
    }

    public int width() {
        return this.width;
    }

    public String[] fieldName() {
        return this.fieldName;
    }

    public String name() {
        return this.strategy().name().toLowerCase();
    }

    public Expression[] arguments() {
        return Transforms.truncate((int)this.width, (String[])this.fieldName).arguments();
    }

    @Override
    public Partitioning.Strategy strategy() {
        return Partitioning.Strategy.TRUNCATE;
    }

    @Override
    public void validate(ColumnDTO[] columns) throws IllegalArgumentException {
        PartitionUtils.validateFieldExistence(columns, this.fieldName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TruncatePartitioningDTO)) {
            return false;
        }
        TruncatePartitioningDTO other = (TruncatePartitioningDTO)o;
        if (this.width != other.width) {
            return false;
        }
        return Arrays.deepEquals(this.fieldName, other.fieldName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.width;
        result = result * 59 + Arrays.deepHashCode(this.fieldName);
        return result;
    }
}

