/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfigs {
    private static final Logger LOG = LoggerFactory.getLogger(SystemConfigs.class);
    public static final ConfigEntry<Integer> WORKER_THREAD_POOL_SIZE = new ConfigEntry<Integer>("iceberg.worker.num-threads", "ICEBERG_WORKER_NUM_THREADS", Math.max(2, Runtime.getRuntime().availableProcessors()), Integer::parseUnsignedInt);
    public static final ConfigEntry<Integer> DELETE_WORKER_THREAD_POOL_SIZE = new ConfigEntry<Integer>("iceberg.worker.delete-num-threads", "ICEBERG_WORKER_DELETE_NUM_THREADS", Math.max(2, 4 * Runtime.getRuntime().availableProcessors()), Integer::parseUnsignedInt);
    public static final ConfigEntry<Boolean> SCAN_THREAD_POOL_ENABLED = new ConfigEntry<Boolean>("iceberg.scan.plan-in-worker-pool", "ICEBERG_SCAN_PLAN_IN_WORKER_POOL", true, Boolean::parseBoolean);
    public static final ConfigEntry<Integer> IO_MANIFEST_CACHE_MAX_FILEIO = new ConfigEntry<Integer>("iceberg.io.manifest.cache.fileio-max", "ICEBERG_IO_MANIFEST_CACHE_FILEIO_MAX", 8, Integer::parseUnsignedInt);
    @Deprecated
    public static final ConfigEntry<Boolean> NETFLIX_UNSAFE_PARQUET_ID_FALLBACK_ENABLED = new ConfigEntry<Boolean>("iceberg.netflix.unsafe-parquet-id-fallback.enabled", "ICEBERG_NETFLIX_UNSAFE_PARQUET_ID_FALLBACK_ENABLED", true, s -> {
        LOG.warn("Fallback ID assignment in Parquet is UNSAFE and will be removed in 2.0.0. Use name mapping instead.");
        return Boolean.parseBoolean(s);
    });

    private SystemConfigs() {
    }

    public static class ConfigEntry<T> {
        private final String propertyKey;
        private final String envKey;
        private final T defaultValue;
        private final Function<String, T> parseFunc;
        private T lazyValue = null;

        private ConfigEntry(String propertyKey, String envKey, T defaultValue, Function<String, T> parseFunc) {
            this.propertyKey = propertyKey;
            this.envKey = envKey;
            this.defaultValue = defaultValue;
            this.parseFunc = parseFunc;
        }

        public final String propertyKey() {
            return this.propertyKey;
        }

        public final String envKey() {
            return this.envKey;
        }

        public final T defaultValue() {
            return this.defaultValue;
        }

        public final T value() {
            if (this.lazyValue == null) {
                this.lazyValue = this.produceValue();
            }
            return this.lazyValue;
        }

        private T produceValue() {
            String value = System.getProperty(this.propertyKey);
            if (value == null) {
                value = System.getenv(this.envKey);
            }
            if (value != null) {
                try {
                    return this.parseFunc.apply(value);
                }
                catch (Exception e) {
                    LOG.error("Failed to parse the config value set by system property: {} or env variable: {}, using the default value: {}", new Object[]{this.propertyKey, this.envKey, this.defaultValue, e});
                }
            }
            return this.defaultValue;
        }
    }
}

