/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.deletes.SortingPositionOnlyDeleteWriter;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FanoutWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.RollingPositionDeleteWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.CharSequenceSet;

public class FanoutPositionOnlyDeleteWriter<T>
extends FanoutWriter<PositionDelete<T>, DeleteWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSizeInBytes;
    private final DeleteGranularity granularity;
    private final List<DeleteFile> deleteFiles;
    private final CharSequenceSet referencedDataFiles;
    private final List<DeleteFile> rewrittenDeleteFiles;
    private final Function<CharSequence, PositionDeleteIndex> loadPreviousDeletes;

    public FanoutPositionOnlyDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes) {
        this(writerFactory, fileFactory, io, targetFileSizeInBytes, DeleteGranularity.PARTITION);
    }

    public FanoutPositionOnlyDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, DeleteGranularity granularity) {
        this(writerFactory, fileFactory, io, targetFileSizeInBytes, granularity, path -> null);
    }

    public FanoutPositionOnlyDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, DeleteGranularity granularity, Function<CharSequence, PositionDeleteIndex> loadPreviousDeletes) {
        this.writerFactory = writerFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.granularity = granularity;
        this.deleteFiles = Lists.newArrayList();
        this.referencedDataFiles = CharSequenceSet.empty();
        this.rewrittenDeleteFiles = Lists.newArrayList();
        this.loadPreviousDeletes = loadPreviousDeletes;
    }

    @Override
    protected FileWriter<PositionDelete<T>, DeleteWriteResult> newWriter(PartitionSpec spec, StructLike partition) {
        return new SortingPositionOnlyDeleteWriter(() -> new RollingPositionDeleteWriter<T>(this.writerFactory, this.fileFactory, this.io, this.targetFileSizeInBytes, spec, partition), this.granularity, this.loadPreviousDeletes);
    }

    @Override
    protected void addResult(DeleteWriteResult result) {
        this.deleteFiles.addAll(result.deleteFiles());
        this.referencedDataFiles.addAll((Collection)result.referencedDataFiles());
        this.rewrittenDeleteFiles.addAll(result.rewrittenDeleteFiles());
    }

    @Override
    protected DeleteWriteResult aggregatedResult() {
        return new DeleteWriteResult(this.deleteFiles, this.referencedDataFiles, this.rewrittenDeleteFiles);
    }
}

