/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer.token;

import com.googlecode.aviator.lexer.token.Token;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AbstractToken<T>
implements Token<T> {
    private static final long serialVersionUID = 4498841242745542399L;
    private final int lineIndex;
    private final int lineNo;
    protected String lexeme;
    private Map<String, Object> metaMap;

    @Override
    public int getLineNo() {
        return this.lineNo;
    }

    @Override
    public Map<String, Object> getMetaMap() {
        return this.metaMap;
    }

    public void setMetaMap(Map<String, Object> metaMap) {
        assert (metaMap == null || metaMap instanceof IdentityHashMap);
        this.metaMap = metaMap;
    }

    @Override
    public Token<T> withMeta(String name, Object v) {
        if (this.metaMap == null) {
            this.metaMap = new IdentityHashMap<String, Object>();
        }
        this.metaMap.put(name, v);
        return this;
    }

    @Override
    public <V> V getMeta(String name, V defaultVal) {
        if (this.metaMap == null) {
            return defaultVal;
        }
        Object val = this.metaMap.get(name);
        if (val == null) {
            return defaultVal;
        }
        return (V)val;
    }

    @Override
    public <V> V getMeta(String name) {
        if (this.metaMap == null) {
            return null;
        }
        return (V)this.metaMap.get(name);
    }

    public AbstractToken(String lexeme, int lineNo, int lineIdex) {
        this.lineNo = lineNo;
        this.lineIndex = lineIdex;
        this.lexeme = lexeme;
    }

    @Override
    public String getLexeme() {
        return this.lexeme;
    }

    @Override
    public int getStartIndex() {
        return this.lineIndex;
    }

    @Override
    public int getEndIndex() {
        return this.lineIndex + (this.lexeme != null ? this.lexeme.length() : 0);
    }

    public String toString() {
        return "[type='" + this.getType().name() + "',lexeme='" + this.getLexeme() + "',index=" + this.lineIndex + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lexeme == null ? 0 : this.lexeme.hashCode());
        result = 31 * result + this.lineIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractToken other = (AbstractToken)obj;
        if (this.lexeme == null ? other.lexeme != null : !this.lexeme.equals(other.lexeme)) {
            return false;
        }
        return this.lineIndex == other.lineIndex;
    }
}

