/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestFileOutputFormat
extends HadoopTestCase {
    public TestFileOutputFormat() throws IOException {
        super(1, 4, 1, 1);
    }

    @Test
    public void testCustomFile() throws Exception {
        FileStatus[] statuses;
        Path inDir = new Path("testing/fileoutputformat/input");
        Path outDir = new Path("testing/fileoutputformat/output");
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            inDir = new Path(localPathRoot, inDir);
            outDir = new Path(localPathRoot, outDir);
        }
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        file = fs.create(new Path(inDir, "part-1"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        conf.setJobName("fof");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(TestMap.class);
        conf.setReducerClass(TestReduce.class);
        conf.set("mapreduce.framework.name", "local");
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobClient jc = new JobClient(conf);
        RunningJob job = jc.submitJob(conf);
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)job.isSuccessful());
        boolean map0 = false;
        boolean map1 = false;
        boolean reduce = false;
        for (FileStatus status : statuses = fs.listStatus(outDir)) {
            map0 = map0 || status.getPath().getName().equals("test-m-00000");
            map1 = map1 || status.getPath().getName().equals("test-m-00001");
            reduce = reduce || status.getPath().getName().equals("test-r-00000");
        }
        Assert.assertTrue((boolean)map0);
        Assert.assertTrue((boolean)map1);
        Assert.assertTrue((boolean)reduce);
    }

    public static class TestReduce
    implements Reducer<LongWritable, Text, LongWritable, Text> {
        public void configure(JobConf conf) {
            try {
                FileSystem fs = FileSystem.get((Configuration)conf);
                FSDataOutputStream os = fs.create(FileOutputFormat.getPathForCustomFile((JobConf)conf, (String)"test"));
                os.write(1);
                os.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void reduce(LongWritable key, Iterator<Text> values, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                Text value = values.next();
                output.collect((Object)key, (Object)value);
            }
        }

        public void close() throws IOException {
        }
    }

    public static class TestMap
    implements Mapper<LongWritable, Text, LongWritable, Text> {
        public void configure(JobConf conf) {
            try {
                FileSystem fs = FileSystem.get((Configuration)conf);
                FSDataOutputStream os = fs.create(FileOutputFormat.getPathForCustomFile((JobConf)conf, (String)"test"));
                os.write(1);
                os.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
            output.collect((Object)key, (Object)value);
        }

        public void close() throws IOException {
        }
    }
}

