/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.InputModeScreenView;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class InputModeScreenPresenter {
    private final InputModeScreenView inputModeScreenView;
    private final String message;
    private final List<String> histories;
    private final Function<String, ScreenView> resultListener;
    private StringBuilder inputString = new StringBuilder();
    private int cursorPosition;
    private int historyPosition = -1;

    public InputModeScreenPresenter(InputModeScreenView inputModeScreenView, String message, @Nullable List<String> histories, Function<String, ScreenView> resultListener) {
        this.inputModeScreenView = Objects.requireNonNull(inputModeScreenView);
        this.message = Objects.requireNonNull(message);
        this.histories = histories != null ? Collections.unmodifiableList(new ArrayList<String>(histories)) : Collections.emptyList();
        this.resultListener = Objects.requireNonNull(resultListener);
    }

    public void init() {
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public ScreenView returnToNextScreen() {
        this.inputModeScreenView.hideCursor();
        String result = this.inputString.toString();
        return this.resultListener.apply(result);
    }

    public void character(Character character) {
        this.inputString.insert(this.cursorPosition, character);
        ++this.cursorPosition;
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public void backspace() {
        if (this.cursorPosition == 0) {
            return;
        }
        this.inputString.deleteCharAt(this.cursorPosition - 1);
        --this.cursorPosition;
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public void delete() {
        if (this.inputString.length() == 0 || this.cursorPosition > this.inputString.length() - 1) {
            return;
        }
        this.inputString.deleteCharAt(this.cursorPosition);
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public void arrowLeft() {
        if (this.cursorPosition == 0) {
            return;
        }
        --this.cursorPosition;
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public void arrowRight() {
        if (this.cursorPosition > this.inputString.length() - 1) {
            return;
        }
        ++this.cursorPosition;
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public void home() {
        this.cursorPosition = 0;
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public void end() {
        this.cursorPosition = this.inputString.length();
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public void arrowUp() {
        if (this.historyPosition == 0 || this.histories.isEmpty()) {
            return;
        }
        this.historyPosition = this.historyPosition == -1 ? this.histories.size() - 1 : --this.historyPosition;
        this.inputString = new StringBuilder(this.histories.get(this.historyPosition));
        this.cursorPosition = this.inputString.length();
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }

    public void arrowDown() {
        if (this.historyPosition == -1 || this.histories.isEmpty()) {
            return;
        }
        if (this.historyPosition == this.histories.size() - 1) {
            this.historyPosition = -1;
            this.inputString = new StringBuilder();
        } else {
            ++this.historyPosition;
            this.inputString = new StringBuilder(this.histories.get(this.historyPosition));
        }
        this.cursorPosition = this.inputString.length();
        this.inputModeScreenView.showInput(this.message, this.inputString.toString(), this.cursorPosition);
        this.inputModeScreenView.refreshTerminal();
    }
}

