/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineExistsFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValuesFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineEntityFiltersType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class TimelineStorageUtils {
    private TimelineStorageUtils() {
    }

    private static boolean matchKeyValuesFilter(TimelineEntity entity, TimelineKeyValuesFilter keyValuesFilter, TimelineEntityFiltersType entityFiltersType) {
        Map relations = null;
        if (entityFiltersType == TimelineEntityFiltersType.IS_RELATED_TO) {
            relations = entity.getIsRelatedToEntities();
        } else if (entityFiltersType == TimelineEntityFiltersType.RELATES_TO) {
            relations = entity.getRelatesToEntities();
        }
        if (relations == null) {
            return false;
        }
        Set ids = (Set)relations.get(keyValuesFilter.getKey());
        if (ids == null) {
            return false;
        }
        boolean matched = false;
        for (Object id : keyValuesFilter.getValues()) {
            matched = !(ids.contains(id) ^ keyValuesFilter.getCompareOp() == TimelineCompareOp.EQUAL);
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static boolean matchRelatesTo(TimelineEntity entity, TimelineFilterList relatesTo) throws IOException {
        return TimelineStorageUtils.matchFilters(entity, relatesTo, TimelineEntityFiltersType.RELATES_TO);
    }

    public static boolean matchIsRelatedTo(TimelineEntity entity, TimelineFilterList isRelatedTo) throws IOException {
        return TimelineStorageUtils.matchFilters(entity, isRelatedTo, TimelineEntityFiltersType.IS_RELATED_TO);
    }

    private static boolean matchKeyValueFilter(TimelineEntity entity, TimelineKeyValueFilter kvFilter, TimelineEntityFiltersType entityFiltersType) {
        Map map = null;
        if (entityFiltersType == TimelineEntityFiltersType.CONFIG) {
            map = entity.getConfigs();
        } else if (entityFiltersType == TimelineEntityFiltersType.INFO) {
            map = entity.getInfo();
        }
        if (map == null) {
            return false;
        }
        Object value = map.get(kvFilter.getKey());
        if (value == null) {
            return false;
        }
        return !(value.equals(kvFilter.getValue()) ^ kvFilter.getCompareOp() == TimelineCompareOp.EQUAL);
    }

    public static boolean matchConfigFilters(TimelineEntity entity, TimelineFilterList configFilters) throws IOException {
        return TimelineStorageUtils.matchFilters(entity, configFilters, TimelineEntityFiltersType.CONFIG);
    }

    public static boolean matchInfoFilters(TimelineEntity entity, TimelineFilterList infoFilters) throws IOException {
        return TimelineStorageUtils.matchFilters(entity, infoFilters, TimelineEntityFiltersType.INFO);
    }

    private static boolean matchExistsFilter(TimelineEntity entity, TimelineExistsFilter existsFilter, TimelineEntityFiltersType entityFiltersType) {
        if (entityFiltersType != TimelineEntityFiltersType.EVENT) {
            return false;
        }
        HashSet<String> eventIds = new HashSet<String>();
        for (TimelineEvent event : entity.getEvents()) {
            eventIds.add(event.getId());
        }
        return !(eventIds.contains(existsFilter.getValue()) ^ existsFilter.getCompareOp() == TimelineCompareOp.EQUAL);
    }

    public static boolean matchEventFilters(TimelineEntity entity, TimelineFilterList eventFilters) throws IOException {
        return TimelineStorageUtils.matchFilters(entity, eventFilters, TimelineEntityFiltersType.EVENT);
    }

    private static boolean compareValues(TimelineCompareOp compareOp, long val1, long val2) {
        switch (compareOp) {
            case LESS_THAN: {
                return val1 < val2;
            }
            case LESS_OR_EQUAL: {
                return val1 <= val2;
            }
            case EQUAL: {
                return val1 == val2;
            }
            case NOT_EQUAL: {
                return val1 != val2;
            }
            case GREATER_OR_EQUAL: {
                return val1 >= val2;
            }
            case GREATER_THAN: {
                return val1 > val2;
            }
        }
        throw new RuntimeException("Unknown TimelineCompareOp " + compareOp.name());
    }

    private static boolean matchCompareFilter(TimelineEntity entity, TimelineCompareFilter compareFilter, TimelineEntityFiltersType entityFiltersType) throws IOException {
        if (entityFiltersType != TimelineEntityFiltersType.METRIC) {
            return false;
        }
        if (!TimelineStorageUtils.isIntegralValue(compareFilter.getValue())) {
            throw new IOException("Metric filters has non integral values");
        }
        HashMap<String, TimelineMetric> metricMap = new HashMap<String, TimelineMetric>();
        for (TimelineMetric metric : entity.getMetrics()) {
            metricMap.put(metric.getId(), metric);
        }
        TimelineMetric metric = (TimelineMetric)metricMap.get(compareFilter.getKey());
        if (metric == null) {
            return false;
        }
        return TimelineStorageUtils.compareValues(compareFilter.getCompareOp(), ((Number)metric.getValuesJAXB().firstEntry().getValue()).longValue(), ((Number)compareFilter.getValue()).longValue());
    }

    public static boolean matchMetricFilters(TimelineEntity entity, TimelineFilterList metricFilters) throws IOException {
        return TimelineStorageUtils.matchFilters(entity, metricFilters, TimelineEntityFiltersType.METRIC);
    }

    private static boolean matchFilters(TimelineEntity entity, TimelineFilterList filters, TimelineEntityFiltersType entityFiltersType) throws IOException {
        if (filters == null || filters.getFilterList().isEmpty()) {
            return false;
        }
        TimelineFilterList.Operator operator = filters.getOperator();
        for (TimelineFilter filter : filters.getFilterList()) {
            TimelineFilter.TimelineFilterType filterType = filter.getFilterType();
            if (!entityFiltersType.isValidFilter(filterType)) {
                throw new IOException("Unsupported filter " + (Object)((Object)filterType));
            }
            boolean matched = false;
            switch (filterType) {
                case LIST: {
                    matched = TimelineStorageUtils.matchFilters(entity, (TimelineFilterList)filter, entityFiltersType);
                    break;
                }
                case COMPARE: {
                    matched = TimelineStorageUtils.matchCompareFilter(entity, (TimelineCompareFilter)filter, entityFiltersType);
                    break;
                }
                case EXISTS: {
                    matched = TimelineStorageUtils.matchExistsFilter(entity, (TimelineExistsFilter)filter, entityFiltersType);
                    break;
                }
                case KEY_VALUE: {
                    matched = TimelineStorageUtils.matchKeyValueFilter(entity, (TimelineKeyValueFilter)filter, entityFiltersType);
                    break;
                }
                case KEY_VALUES: {
                    matched = TimelineStorageUtils.matchKeyValuesFilter(entity, (TimelineKeyValuesFilter)filter, entityFiltersType);
                    break;
                }
                default: {
                    throw new IOException("Unsupported filter " + (Object)((Object)filterType));
                }
            }
            if (!matched) {
                if (operator != TimelineFilterList.Operator.AND) continue;
                return false;
            }
            if (operator != TimelineFilterList.Operator.OR) continue;
            return true;
        }
        return operator == TimelineFilterList.Operator.AND;
    }

    public static boolean isIntegralValue(Object obj) {
        return obj instanceof Short || obj instanceof Integer || obj instanceof Long;
    }
}

