/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.KeyFieldBasedPartitioner;
import org.junit.Assert;
import org.junit.Test;

public class TestKeyFieldBasedPartitioner {
    @Test
    public void testEmptyKey() throws Exception {
        KeyFieldBasedPartitioner kfbp = new KeyFieldBasedPartitioner();
        JobConf conf = new JobConf();
        conf.setInt("num.key.fields.for.partition", 10);
        kfbp.configure(conf);
        Assert.assertEquals((String)"Empty key should map to 0th partition", (long)0L, (long)kfbp.getPartition((Object)new Text(), (Object)new Text(), 10));
    }

    @Test
    public void testMultiConfigure() {
        KeyFieldBasedPartitioner kfbp = new KeyFieldBasedPartitioner();
        JobConf conf = new JobConf();
        conf.set(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS, "-k1,1");
        kfbp.setConf((Configuration)conf);
        Text key = new Text("foo\tbar");
        Text val = new Text("val");
        int partNum = kfbp.getPartition((Object)key, (Object)val, 4096);
        kfbp.configure(conf);
        Assert.assertEquals((long)partNum, (long)kfbp.getPartition((Object)key, (Object)val, 4096));
    }
}

