/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.lz4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.lz4.Lz4Compressor;
import org.apache.hadoop.hbase.io.compress.lz4.Lz4Decompressor;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Lz4Codec
implements Configurable,
CompressionCodec {
    public static final String LZ4_BUFFER_SIZE_KEY = "hbase.io.compress.lz4.buffersize";
    private Configuration conf = new Configuration();
    private int bufferSize = Lz4Codec.getBufferSize(this.conf);

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.bufferSize = Lz4Codec.getBufferSize(conf);
    }

    public Compressor createCompressor() {
        return new Lz4Compressor(this.bufferSize);
    }

    public Decompressor createDecompressor() {
        return new Lz4Decompressor(this.bufferSize);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new BlockDecompressorStream(in, d, this.bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor c) throws IOException {
        return new BlockCompressorStream(out, c, this.bufferSize, CompressionUtil.compressionOverhead((int)this.bufferSize));
    }

    public Class<? extends Compressor> getCompressorType() {
        return Lz4Compressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return Lz4Decompressor.class;
    }

    public String getDefaultExtension() {
        return ".lz4";
    }

    static int getBufferSize(Configuration conf) {
        return conf.getInt(LZ4_BUFFER_SIZE_KEY, conf.getInt("io.compression.codec.lz4.buffersize", 262144));
    }
}

