/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public abstract class CachingCallSite
extends CallSite {
    protected CacheEntry cache = CacheEntry.NULL_CACHE;
    @Deprecated
    protected CacheEntry builtinCache = CacheEntry.NULL_CACHE;

    public CachingCallSite(String methodName, CallType callType) {
        super(methodName, callType);
    }

    public final CacheEntry getCache() {
        return this.cache;
    }

    protected CacheEntry setCache(CacheEntry entry, IRubyObject self2) {
        this.cache = entry;
        return this.cache;
    }

    public final boolean isOptimizable() {
        return this.cache != CacheEntry.NULL_CACHE;
    }

    public final int getCachedClassIndex() {
        CacheEntry cache = this.cache;
        if (cache != CacheEntry.NULL_CACHE) {
            return cache.method.getImplementationClass().getClassIndex().ordinal();
        }
        return ClassIndex.NO_INDEX.ordinal();
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final long getCachedMethodSerial() {
        CacheEntry cache = this.cache;
        if (cache != CacheEntry.NULL_CACHE) {
            return cache.method.getSerialNumber();
        }
        return -1L;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, long fixnum) {
        return this.call(context, caller2, self2, (IRubyObject)RubyFixnum.newFixnum(context.runtime, fixnum));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, double flote) {
        return this.call(context, caller2, self2, (IRubyObject)RubyFloat.newFloat(context.runtime, flote));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject ... args2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, args2);
        }
        return this.cacheAndCall(caller2, selfType, args2, context, self2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, args2, block);
        }
        return this.cacheAndCall(caller2, selfType, block, args2, context, self2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public final IRubyObject callVarargs(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject ... args2) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller2, self2);
            }
            case 1: {
                return this.call(context, caller2, self2, args2[0]);
            }
            case 2: {
                return this.call(context, caller2, self2, args2[0], args2[1]);
            }
            case 3: {
                return this.call(context, caller2, self2, args2[0], args2[1], args2[2]);
            }
        }
        return this.call(context, caller2, self2, args2);
    }

    @Override
    public final IRubyObject callVarargs(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller2, self2, block);
            }
            case 1: {
                return this.call(context, caller2, self2, args2[0], block);
            }
            case 2: {
                return this.call(context, caller2, self2, args2[0], args2[1], block);
            }
            case 3: {
                return this.call(context, caller2, self2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.call(context, caller2, self2, args2, block);
    }

    @Override
    public final IRubyObject callVarargsIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.callIter(context, caller2, self2, block);
            }
            case 1: {
                return this.callIter(context, caller2, self2, args2[0], block);
            }
            case 2: {
                return this.callIter(context, caller2, self2, args2[0], args2[1], block);
            }
            case 3: {
                return this.callIter(context, caller2, self2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.callIter(context, caller2, self2, args2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName);
        }
        return this.cacheAndCall(caller2, selfType, context, self2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1);
        }
        return this.cacheAndCall(caller2, selfType, context, self2, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self2, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, arg1, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, arg2);
        }
        return this.cacheAndCall(caller2, selfType, context, self2, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, arg2, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self2, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, arg1, arg2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, arg2, arg3);
        }
        return this.cacheAndCall(caller2, selfType, context, self2, arg1, arg2, arg3);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.call(context, self2, cache.sourceModule, this.methodName, arg1, arg2, arg3, block);
        }
        return this.cacheAndCall(caller2, selfType, block, context, self2, arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IRubyObject callIter(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            IRubyObject iRubyObject = this.call(context, caller2, self2, arg1, arg2, arg3, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    public final CacheEntry retrieveCache(IRubyObject self2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache;
        }
        return this.cacheAndGet(self2, selfType, this.methodName);
    }

    @Deprecated
    public final CacheEntry retrieveCache(RubyClass selfType) {
        CacheEntry cache = this.cache;
        if (cache.typeOk(selfType)) {
            return cache;
        }
        return this.cacheAndGet(selfType, this.methodName);
    }

    @Deprecated
    public final CacheEntry retrieveCache(RubyClass selfType, String methodName) {
        CacheEntry cache = this.cache;
        if (cache.typeOk(selfType)) {
            return cache;
        }
        return this.cacheAndGet(selfType, methodName);
    }

    public boolean isBuiltin(IRubyObject self2) {
        CacheEntry cache = this.cache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.isBuiltin();
        }
        return this.cacheAndGet((IRubyObject)self2, (RubyClass)selfType, (String)this.methodName).method.isBuiltin();
    }

    @Deprecated
    public final boolean isBuiltin(RubyClass selfType) {
        CacheEntry cache = this.cache;
        if (cache.typeOk(selfType)) {
            return cache.method.isBuiltin();
        }
        return this.cacheAndGet((RubyClass)selfType, (String)this.methodName).method.isBuiltin();
    }

    @Deprecated
    private CacheEntry cacheAndGet(RubyClass selfType, String methodName) {
        CacheEntry entry = selfType.searchWithCache(methodName);
        if (!entry.method.isUndefined()) {
            this.cache = entry;
            if (entry.method.isBuiltin()) {
                this.builtinCache = entry;
            }
        }
        return entry;
    }

    private CacheEntry cacheAndGet(IRubyObject self2, RubyClass selfType, String methodName) {
        CacheEntry entry = selfType.searchWithCache(methodName);
        if (!entry.method.isUndefined()) {
            entry = this.setCache(entry, self2);
        }
        return entry;
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, args2, block);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, args2, block);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, args2);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, args2);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, block);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg2);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg2);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg2, block);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg1, arg2);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg1, arg2);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg1, arg2, block);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg1, arg2, block);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg1, arg2, arg3);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg1, arg2, arg3);
    }

    private IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self2, selfType, method2, arg1, arg2, arg3, block);
        }
        entry = this.setCache(entry, self2);
        return method2.call(context, self2, entry.sourceModule, this.methodName, arg1, arg2, arg3, block);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, IRubyObject[] args2) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)selfType, this.methodName, args2, Block.NULL_BLOCK);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)selfType, this.methodName, Block.NULL_BLOCK);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, Block block) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)selfType, this.methodName, block);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, IRubyObject arg2) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)selfType, this.methodName, arg2, Block.NULL_BLOCK);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, IRubyObject[] args2, Block block) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)selfType, this.methodName, args2, block);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, IRubyObject arg0, Block block) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)selfType, this.methodName, arg0, block);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)selfType, this.methodName, arg0, arg1, Block.NULL_BLOCK);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, (RubyModule)selfType, this.methodName, arg0, arg1, block);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, selfType, this.methodName, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    protected final IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass selfType, DynamicMethod method2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.selectMethodMissing(context, selfType, method2.getVisibility(), this.methodName, this.callType).call(context, self2, self2.getMetaClass(), this.methodName, arg0, arg1, arg2, block);
    }

    protected boolean methodMissing(DynamicMethod method2, IRubyObject caller2) {
        return method2.isUndefined() || !this.methodName.equals("method_missing") && !method2.isCallableFrom(caller2, this.callType);
    }

    protected static RubyClass getClass(IRubyObject self2) {
        return RubyBasicObject.getMetaClass(self2);
    }
}

