/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.customizedstate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CustomizedState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.ZNRecordDelta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedStateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CustomizedStateProvider.class);
    private final HelixManager _helixManager;
    private String _instanceName;

    public CustomizedStateProvider(HelixManager helixManager, String instanceName) {
        this._helixManager = helixManager;
        this._instanceName = instanceName;
    }

    public void updateCustomizedState(String customizedStateName, String resourceName, String partitionName, String customizedState) {
        HashMap<String, String> customizedStateMap = new HashMap<String, String>();
        customizedStateMap.put(CustomizedState.CustomizedStateProperty.CURRENT_STATE.name(), customizedState);
        this.updateCustomizedState(customizedStateName, resourceName, partitionName, customizedStateMap);
    }

    public void updateCustomizedState(String customizedStateName, String resourceName, String partitionName, Map<String, String> customizedStateMap) {
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        PropertyKey propertyKey = keyBuilder.customizedState(this._instanceName, customizedStateName, resourceName);
        ZNRecord record = new ZNRecord(resourceName);
        customizedStateMap.put(CustomizedState.CustomizedStateProperty.START_TIME.name(), String.valueOf(System.currentTimeMillis()));
        record.setMapField(partitionName, customizedStateMap);
        if (!accessor.updateProperty(propertyKey, new CustomizedState(record))) {
            throw new HelixException(String.format("Failed to persist customized state %s to zk for instance %s, resource %s, partition %s", customizedStateName, this._instanceName, resourceName, partitionName));
        }
    }

    public CustomizedState getCustomizedState(String customizedStateName, String resourceName) {
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (CustomizedState)accessor.getProperty(keyBuilder.customizedState(this._instanceName, customizedStateName, resourceName));
    }

    public Map<String, String> getPerPartitionCustomizedState(String customizedStateName, String resourceName, String partitionName) {
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        Map<String, Map<String, String>> mapView = ((HelixProperty)accessor.getProperty(keyBuilder.customizedState(this._instanceName, customizedStateName, resourceName))).getRecord().getMapFields();
        return mapView.get(partitionName);
    }

    public void deletePerPartitionCustomizedState(String customizedStateName, String resourceName, String partitionName) {
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        PropertyKey propertyKey = keyBuilder.customizedState(this._instanceName, customizedStateName, resourceName);
        CustomizedState existingState = this.getCustomizedState(customizedStateName, resourceName);
        ZNRecord rec = new ZNRecord(existingState.getId());
        rec.getMapFields().put(partitionName, null);
        ZNRecordDelta delta = new ZNRecordDelta(rec, ZNRecordDelta.MergeOperation.SUBTRACT);
        ArrayList<ZNRecordDelta> deltaList = new ArrayList<ZNRecordDelta>();
        deltaList.add(delta);
        existingState.setDeltaList(deltaList);
        if (!accessor.updateProperty(propertyKey, existingState)) {
            throw new HelixException(String.format("Failed to delete customized state %s to zk for instance %s, resource %s, partition %s", customizedStateName, this._instanceName, resourceName, partitionName));
        }
    }

    public void deleteResourceCustomizedState(String customizedStateName, String resourceName) {
        PropertyKey resourceCustomizedStateKey;
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        if (!accessor.removeProperty(resourceCustomizedStateKey = accessor.keyBuilder().customizedState(this._instanceName, customizedStateName, resourceName))) {
            throw new HelixException(String.format("Failed to delete customized state %s in ZooKeeper for instance %s, resource %s", customizedStateName, this._instanceName, resourceName));
        }
    }

    public void deleteAllResourcesCustomizedStates(String customizedStateName) {
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        PropertyKey customizedStateKey = accessor.keyBuilder().customizedStates(this._instanceName, customizedStateName);
        List<String> resourceNames = accessor.getChildNames(customizedStateKey);
        for (String resourceName : resourceNames) {
            this.deleteResourceCustomizedState(customizedStateName, resourceName);
        }
    }
}

