/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrivateKeyUtils {
    private static final Logger log = LoggerFactory.getLogger(PrivateKeyUtils.class);
    private static final String KEY_PATH = System.getProperty("user.home") + "/.ssh";

    public static String writePrivateKey(String host, String keyStr) throws IOException {
        Path keyPath;
        Path sshPath = Paths.get(KEY_PATH, new String[0]);
        if (!Files.exists(sshPath, new LinkOption[0])) {
            Files.createDirectories(sshPath, new FileAttribute[0]);
        }
        if (!Files.exists(keyPath = Paths.get(KEY_PATH, "id_rsa_" + host), new LinkOption[0])) {
            Files.writeString(keyPath, (CharSequence)keyStr, new OpenOption[0]);
        } else {
            String oldKey = Files.readString(keyPath);
            if (!Objects.equals(oldKey, keyStr)) {
                Files.writeString(keyPath, (CharSequence)keyStr, new OpenOption[0]);
            }
        }
        return keyPath.toString();
    }

    private PrivateKeyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

