/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.InternalProducerAttr;
import reactor.core.publisher.ParallelFlux;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class ParallelFluxName<T>
extends ParallelFlux<T>
implements Scannable {
    final ParallelFlux<T> source;
    final String name;
    final List<Tuple2<String, String>> tagsWithDuplicates;

    static <T> ParallelFlux<T> createOrAppend(ParallelFlux<T> source, String name) {
        Objects.requireNonNull(name, "name");
        if (source instanceof ParallelFluxName) {
            ParallelFluxName s = (ParallelFluxName)source;
            return new ParallelFluxName<T>(s.source, name, s.tagsWithDuplicates);
        }
        return new ParallelFluxName<T>(source, name, null);
    }

    static <T> ParallelFlux<T> createOrAppend(ParallelFlux<T> source, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Tuple2<String, String> newTag = Tuples.of(tagName, tagValue);
        if (source instanceof ParallelFluxName) {
            List<Tuple2<String, String>> tags;
            ParallelFluxName s = (ParallelFluxName)source;
            if (s.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new ParallelFluxName<T>(s.source, s.name, tags);
        }
        return new ParallelFluxName<T>(source, null, Collections.singletonList(newTag));
    }

    ParallelFluxName(ParallelFlux<T> source, @Nullable String name, @Nullable List<Tuple2<String, String>> tags) {
        this.source = ParallelFlux.from(source);
        this.name = name;
        this.tagsWithDuplicates = tags;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tagsWithDuplicates != null) {
            return this.tagsWithDuplicates.stream();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        this.source.subscribe(subscribers);
    }
}

