/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.thetacommon.ThetaUtil;

final class AnotBimpl
extends AnotB {
    private final short seedHash_;
    private boolean empty_;
    private long thetaLong_;
    private long[] hashArr_ = new long[0];
    private int curCount_;

    AnotBimpl(long seed) {
        this(ThetaUtil.computeSeedHash(seed));
    }

    private AnotBimpl(short seedHash) {
        this.seedHash_ = seedHash;
        this.reset();
    }

    @Override
    public void setA(Sketch skA) {
        if (skA == null) {
            this.reset();
            throw new SketchesArgumentException("The input argument <i>A</i> must not be null");
        }
        if (skA.isEmpty()) {
            this.reset();
            return;
        }
        ThetaUtil.checkSeedHashes(this.seedHash_, skA.getSeedHash());
        this.hashArr_ = AnotBimpl.getHashArrA(skA);
        this.empty_ = false;
        this.thetaLong_ = skA.getThetaLong();
        this.curCount_ = this.hashArr_.length;
    }

    @Override
    public void notB(Sketch skB) {
        if (this.empty_ || skB == null || skB.isEmpty()) {
            return;
        }
        ThetaUtil.checkSeedHashes(this.seedHash_, skB.getSeedHash());
        this.thetaLong_ = Math.min(this.thetaLong_, skB.getThetaLong());
        this.hashArr_ = AnotBimpl.getResultHashArr(this.thetaLong_, this.curCount_, this.hashArr_, skB);
        this.curCount_ = this.hashArr_.length;
        this.empty_ = this.curCount_ == 0 && this.thetaLong_ == Long.MAX_VALUE;
    }

    @Override
    public CompactSketch getResult(boolean reset) {
        return this.getResult(true, null, reset);
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, WritableMemory dstMem, boolean reset) {
        CompactSketch result = CompactOperations.componentsToCompact(this.thetaLong_, this.curCount_, this.seedHash_, this.empty_, true, false, dstOrdered, dstMem, (long[])this.hashArr_.clone());
        if (reset) {
            this.reset();
        }
        return result;
    }

    @Override
    public CompactSketch aNotB(Sketch skA, Sketch skB, boolean dstOrdered, WritableMemory dstMem) {
        if (skA == null || skB == null) {
            throw new SketchesArgumentException("Neither argument may be null");
        }
        long minThetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        if (skA.isEmpty()) {
            return skA.compact(dstOrdered, dstMem);
        }
        ThetaUtil.checkSeedHashes(skA.getSeedHash(), this.seedHash_);
        if (skB.isEmpty()) {
            return skA.compact(dstOrdered, dstMem);
        }
        ThetaUtil.checkSeedHashes(skB.getSeedHash(), this.seedHash_);
        long[] hashArrA = AnotBimpl.getHashArrA(skA);
        int countA = hashArrA.length;
        long[] hashArrOut = AnotBimpl.getResultHashArr(minThetaLong, countA, hashArrA, skB);
        int countOut = hashArrOut.length;
        boolean empty = countOut == 0 && minThetaLong == Long.MAX_VALUE;
        CompactSketch result = CompactOperations.componentsToCompact(minThetaLong, countOut, this.seedHash_, empty, true, false, dstOrdered, dstMem, hashArrOut);
        return result;
    }

    @Override
    int getRetainedEntries() {
        return this.curCount_;
    }

    @Override
    public boolean isSameResource(Memory that) {
        return false;
    }

    private static long[] getHashArrA(Sketch skA) {
        CompactSketch cskA = skA.compact(false, null);
        long[] hashArrA = (long[])cskA.getCache().clone();
        return hashArrA;
    }

    private static long[] getResultHashArr(long minThetaLong, int countA, long[] hashArrA, Sketch skB) {
        long[] thetaCache = skB.getCache();
        int countB = skB.getRetainedEntries(true);
        long[] hashTableB = skB instanceof CompactSketch ? HashOperations.convertToHashTable(thetaCache, countB, minThetaLong, 0.9375) : thetaCache;
        long[] tmpHashArrA = new long[countA];
        int lgHTBLen = Util.exactLog2OfLong(hashTableB.length);
        int nonMatches = 0;
        for (int i = 0; i < countA; ++i) {
            int index;
            long hash = hashArrA[i];
            if (hash == 0L || hash >= minThetaLong || (index = HashOperations.hashSearch(hashTableB, lgHTBLen, hash)) != -1) continue;
            tmpHashArrA[nonMatches] = hash;
            ++nonMatches;
        }
        return Arrays.copyOfRange(tmpHashArrA, 0, nonMatches);
    }

    private void reset() {
        this.thetaLong_ = Long.MAX_VALUE;
        this.empty_ = true;
        this.hashArr_ = new long[0];
        this.curCount_ = 0;
    }

    @Override
    long[] getCache() {
        return (long[])this.hashArr_.clone();
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    boolean isEmpty() {
        return this.empty_;
    }
}

