/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.ColumnarRowResultIterator;
import org.apache.kudu.client.FaultTolerantScannerExpiredException;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.NonCoveredRangeException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionPruner;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.ResourceMetrics;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.RowwiseRowResultIterator;
import org.apache.kudu.client.Status;
import org.apache.kudu.security.Token;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class AsyncKuduScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncKuduScanner.class);
    static final String DEFAULT_IS_DELETED_COL_NAME = "is_deleted";
    private final AsyncKuduClient client;
    private final KuduTable table;
    private final Schema schema;
    private final PartitionPruner pruner;
    private final Map<String, KuduPredicate> predicates;
    private final int batchSizeBytes;
    private final long limit;
    private final byte[] startPrimaryKey;
    private final byte[] endPrimaryKey;
    private byte[] lastPrimaryKey;
    private final boolean prefetching;
    private final boolean cacheBlocks;
    private final ReadMode readMode;
    private final Common.OrderMode orderMode;
    private final boolean isFaultTolerant;
    private final long startTimestamp;
    private long htTimestamp;
    private long lowerBoundPropagationTimestamp = -1L;
    private final ReplicaSelection replicaSelection;
    private final long keepAlivePeriodMs;
    private boolean reuseRowResult = false;
    private final ResourceMetrics resourceMetrics = new ResourceMetrics();
    private boolean closed = false;
    private boolean canRequestMore = true;
    private long numRowsReturned = 0L;
    private RowDataFormat rowDataFormat = RowDataFormat.ROWWISE;
    private RemoteTablet tablet;
    private byte[] scannerId;
    private int sequenceId;
    final long scanRequestTimeout;
    private AtomicReference<Deferred<RowResultIterator>> cachedPrefetcherDeferred = new AtomicReference();
    private final Callback<RowResultIterator, RowResultIterator> prefetch = new Callback<RowResultIterator, RowResultIterator>(){

        @Override
        public RowResultIterator call(RowResultIterator arg) throws Exception {
            if (AsyncKuduScanner.this.canRequestMore && AsyncKuduScanner.this.cachedPrefetcherDeferred.get() == null) {
                Deferred prefetcherDeferred = AsyncKuduScanner.this.client.scanNextRows(AsyncKuduScanner.this).addCallbacks(AsyncKuduScanner.this.gotNextRow, AsyncKuduScanner.this.nextRowErrback());
                if (!AsyncKuduScanner.this.cachedPrefetcherDeferred.compareAndSet(null, prefetcherDeferred)) {
                    LOG.info("Skip one prefetching because two concurrent prefetching scan occurs");
                }
            }
            return null;
        }
    };
    private final Callback<RowResultIterator, Response> gotNextRow = new Callback<RowResultIterator, Response>(){

        @Override
        public RowResultIterator call(Response resp) {
            long lastPropagatedTimestamp = -1L;
            if (AsyncKuduScanner.this.readMode == ReadMode.READ_YOUR_WRITES && resp.scanTimestamp != -1L) {
                lastPropagatedTimestamp = resp.scanTimestamp;
            } else if (resp.propagatedTimestamp != -1L) {
                lastPropagatedTimestamp = resp.propagatedTimestamp;
            }
            if (lastPropagatedTimestamp != -1L) {
                AsyncKuduScanner.this.client.updateLastPropagatedTimestamp(lastPropagatedTimestamp);
            }
            AsyncKuduScanner.this.numRowsReturned += resp.data.getNumRows();
            if (AsyncKuduScanner.this.isFaultTolerant && resp.lastPrimaryKey != null) {
                AsyncKuduScanner.access$702(AsyncKuduScanner.this, resp.lastPrimaryKey);
            }
            if (resp.resourceMetricsPb != null) {
                AsyncKuduScanner.this.resourceMetrics.update(resp.resourceMetricsPb);
            }
            if (!resp.more) {
                AsyncKuduScanner.this.scanFinished();
                return resp.data;
            }
            AsyncKuduScanner.this.sequenceId++;
            AsyncKuduScanner.this.canRequestMore = resp.more;
            return resp.data;
        }

        public String toString() {
            return "get nextRows response";
        }
    };

    boolean canBeIgnored(Tserver.TabletServerErrorPB.Code errorCode) {
        return errorCode == Tserver.TabletServerErrorPB.Code.SCANNER_EXPIRED && this.prefetching && this.closed;
    }

    AsyncKuduScanner(AsyncKuduClient client, KuduTable table, List<String> projectedNames, List<Integer> projectedIndexes, ReadMode readMode, boolean isFaultTolerant, long scanRequestTimeout, Map<String, KuduPredicate> predicates, long limit, boolean cacheBlocks, boolean prefetching, byte[] startPrimaryKey, byte[] endPrimaryKey, long startTimestamp, long htTimestamp, int batchSizeBytes, PartitionPruner pruner, ReplicaSelection replicaSelection, long keepAlivePeriodMs) {
        Preconditions.checkArgument(batchSizeBytes >= 0, "Need non-negative number of bytes, got %s", batchSizeBytes);
        Preconditions.checkArgument(limit > 0L, "Need a strictly positive number for the limit, got %s", limit);
        if (htTimestamp != -1L) {
            Preconditions.checkArgument(htTimestamp >= 0L, "Need non-negative number for the scan,  timestamp got %s", htTimestamp);
            Preconditions.checkArgument(readMode == ReadMode.READ_AT_SNAPSHOT, "When specifying a HybridClock timestamp, the read mode needs to be set to READ_AT_SNAPSHOT");
        }
        if (startTimestamp != -1L) {
            Preconditions.checkArgument(htTimestamp >= 0L, "Must have both start and end timestamps for a diff scan");
            Preconditions.checkArgument(startTimestamp <= htTimestamp, "Start timestamp must be less than or equal to end timestamp");
        }
        this.isFaultTolerant = isFaultTolerant;
        if (this.isFaultTolerant) {
            Preconditions.checkArgument(readMode == ReadMode.READ_AT_SNAPSHOT, "Use of fault tolerance scanner requires the read mode to be set to READ_AT_SNAPSHOT");
            this.orderMode = Common.OrderMode.ORDERED;
        } else {
            this.orderMode = Common.OrderMode.UNORDERED;
        }
        this.client = client;
        this.table = table;
        this.pruner = pruner;
        this.readMode = readMode;
        this.scanRequestTimeout = scanRequestTimeout;
        this.predicates = predicates;
        this.limit = limit;
        this.cacheBlocks = cacheBlocks;
        this.prefetching = prefetching;
        this.startPrimaryKey = startPrimaryKey;
        this.endPrimaryKey = endPrimaryKey;
        this.startTimestamp = startTimestamp;
        this.htTimestamp = htTimestamp;
        this.batchSizeBytes = batchSizeBytes;
        this.lastPrimaryKey = AsyncKuduClient.EMPTY_ARRAY;
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        if (projectedNames != null) {
            for (String columnName : projectedNames) {
                ColumnSchema originalColumn = table.getSchema().getColumn(columnName);
                columns.add(AsyncKuduScanner.getStrippedColumnSchema(originalColumn));
            }
        } else if (projectedIndexes != null) {
            for (Integer columnIndex : projectedIndexes) {
                ColumnSchema originalColumn = table.getSchema().getColumnByIndex(columnIndex);
                columns.add(AsyncKuduScanner.getStrippedColumnSchema(originalColumn));
            }
        } else {
            columns.addAll(table.getSchema().getColumns());
        }
        if (startTimestamp != -1L) {
            columns.add(AsyncKuduScanner.generateIsDeletedColumn(table.getSchema()));
        }
        this.schema = new Schema(columns);
        if (!pruner.hasMorePartitionKeyRanges()) {
            LOG.debug("Short circuiting scan");
            this.canRequestMore = false;
            this.closed = true;
        }
        this.replicaSelection = replicaSelection;
        this.keepAlivePeriodMs = keepAlivePeriodMs;
        if (readMode == ReadMode.READ_YOUR_WRITES) {
            this.lowerBoundPropagationTimestamp = this.client.getLastPropagatedTimestamp();
        }
    }

    private static ColumnSchema generateIsDeletedColumn(Schema schema) {
        StringBuilder columnName = new StringBuilder(DEFAULT_IS_DELETED_COL_NAME);
        while (schema.hasColumn(columnName.toString())) {
            columnName.append("_");
        }
        return new ColumnSchema.ColumnSchemaBuilder(columnName.toString(), Type.BOOL).wireType(Common.DataType.IS_DELETED).defaultValue(false).nullable(false).key(false).build();
    }

    private static ColumnSchema getStrippedColumnSchema(ColumnSchema columnToClone) {
        return new ColumnSchema.ColumnSchemaBuilder(columnToClone).key(false).build();
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean hasMoreRows() {
        return this.canRequestMore || this.cachedPrefetcherDeferred.get() != null;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public long getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    public ReadMode getReadMode() {
        return this.readMode;
    }

    private Common.OrderMode getOrderMode() {
        return this.orderMode;
    }

    public long getScanRequestTimeout() {
        return this.scanRequestTimeout;
    }

    public Schema getProjectionSchema() {
        return this.schema;
    }

    public long getKeepAlivePeriodMs() {
        return this.keepAlivePeriodMs;
    }

    long getStartSnapshotTimestamp() {
        return this.startTimestamp;
    }

    public ResourceMetrics getResourceMetrics() {
        return this.resourceMetrics;
    }

    long getSnapshotTimestamp() {
        return this.htTimestamp;
    }

    public void setReuseRowResult(boolean reuseRowResult) {
        this.reuseRowResult = reuseRowResult;
    }

    public void setRowDataFormat(RowDataFormat rowDataFormat) {
        this.rowDataFormat = rowDataFormat;
    }

    public Deferred<RowResultIterator> nextRows() {
        if (this.closed) {
            if (this.prefetching && this.cachedPrefetcherDeferred.get() != null) {
                return this.cachedPrefetcherDeferred.getAndUpdate(v -> null);
            }
            return Deferred.fromResult(null);
        }
        if (this.tablet == null) {
            Callback<Deferred<RowResultIterator>, Response> cb = new Callback<Deferred<RowResultIterator>, Response>(){

                @Override
                public Deferred<RowResultIterator> call(Response resp) throws Exception {
                    if (AsyncKuduScanner.this.htTimestamp == -1L && resp.scanTimestamp != -1L) {
                        AsyncKuduScanner.this.htTimestamp = resp.scanTimestamp;
                    }
                    long lastPropagatedTimestamp = -1L;
                    if (AsyncKuduScanner.this.readMode == ReadMode.READ_YOUR_WRITES && resp.scanTimestamp != -1L) {
                        lastPropagatedTimestamp = resp.scanTimestamp;
                    } else if (resp.propagatedTimestamp != -1L) {
                        lastPropagatedTimestamp = resp.propagatedTimestamp;
                    }
                    if (lastPropagatedTimestamp != -1L) {
                        AsyncKuduScanner.this.client.updateLastPropagatedTimestamp(lastPropagatedTimestamp);
                    }
                    if (AsyncKuduScanner.this.isFaultTolerant && resp.lastPrimaryKey != null) {
                        AsyncKuduScanner.access$702(AsyncKuduScanner.this, resp.lastPrimaryKey);
                    }
                    AsyncKuduScanner.this.numRowsReturned += resp.data.getNumRows();
                    if (resp.resourceMetricsPb != null) {
                        AsyncKuduScanner.this.resourceMetrics.update(resp.resourceMetricsPb);
                    }
                    if (!resp.more || resp.scannerId == null) {
                        AsyncKuduScanner.this.scanFinished();
                        return Deferred.fromResult(resp.data);
                    }
                    AsyncKuduScanner.access$1402(AsyncKuduScanner.this, resp.scannerId);
                    AsyncKuduScanner.this.sequenceId++;
                    AsyncKuduScanner.this.canRequestMore = resp.more;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scanner {} opened on {}", (Object)Bytes.pretty(AsyncKuduScanner.this.scannerId), (Object)AsyncKuduScanner.this.tablet);
                    }
                    return Deferred.fromResult(resp.data);
                }

                public String toString() {
                    return "scanner opened";
                }
            };
            Callback<Deferred<RowResultIterator>, Exception> eb = new Callback<Deferred<RowResultIterator>, Exception>(){

                @Override
                public Deferred<RowResultIterator> call(Exception e) throws Exception {
                    AsyncKuduScanner.this.invalidate();
                    if (e instanceof NonCoveredRangeException) {
                        NonCoveredRangeException ncre = (NonCoveredRangeException)e;
                        AsyncKuduScanner.this.pruner.removePartitionKeyRange(ncre.getNonCoveredRangeEnd());
                        if (!AsyncKuduScanner.this.pruner.hasMorePartitionKeyRanges()) {
                            AsyncKuduScanner.this.canRequestMore = false;
                            AsyncKuduScanner.this.closed = true;
                            return Deferred.fromResult(RowResultIterator.empty());
                        }
                        AsyncKuduScanner.access$1402(AsyncKuduScanner.this, null);
                        AsyncKuduScanner.this.sequenceId = 0;
                        return AsyncKuduScanner.this.nextRows();
                    }
                    LOG.debug("Can not open scanner", (Throwable)e);
                    return Deferred.fromError(e);
                }

                public String toString() {
                    return "open scanner errback";
                }
            };
            return this.client.sendRpcToTablet(this.getOpenRequest()).addCallbackDeferring(cb).addErrback(eb);
        }
        if (this.prefetching && this.cachedPrefetcherDeferred.get() != null) {
            Deferred<RowResultIterator> prefetcherDeferred = this.cachedPrefetcherDeferred.getAndUpdate(v -> null);
            prefetcherDeferred.chain(new Deferred<RowResultIterator>().addCallback(this.prefetch));
            return prefetcherDeferred;
        }
        Deferred<RowResultIterator> d = this.client.scanNextRows(this).addCallbacks(this.gotNextRow, this.nextRowErrback());
        if (this.prefetching) {
            d.chain(new Deferred<RowResultIterator>().addCallback(this.prefetch));
        }
        return d;
    }

    private final Callback<Deferred<RowResultIterator>, Exception> nextRowErrback() {
        return new Callback<Deferred<RowResultIterator>, Exception>(){

            @Override
            public Deferred<RowResultIterator> call(Exception e) throws Exception {
                RemoteTablet old_tablet = AsyncKuduScanner.this.tablet;
                AsyncKuduScanner.this.invalidate();
                if (e instanceof FaultTolerantScannerExpiredException) {
                    AsyncKuduScanner.access$1402(AsyncKuduScanner.this, null);
                    AsyncKuduScanner.this.sequenceId = 0;
                    LOG.warn("Scanner expired, creating a new one {}", (Object)AsyncKuduScanner.this);
                    return AsyncKuduScanner.this.nextRows();
                }
                LOG.warn("{} pretends to not know {}", new Object[]{old_tablet, AsyncKuduScanner.this, e});
                return Deferred.fromError(e);
            }

            public String toString() {
                return "NextRow errback";
            }
        };
    }

    void scanFinished() {
        Partition partition = this.tablet.getPartition();
        this.pruner.removePartitionKeyRange(partition.getPartitionKeyEnd());
        if (!this.pruner.hasMorePartitionKeyRanges() || this.numRowsReturned >= this.limit) {
            this.canRequestMore = false;
            this.closed = true;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done scanning tablet {} for partition {} with scanner id {}", new Object[]{this.tablet.getTabletId(), this.tablet.getPartition(), Bytes.pretty(this.scannerId)});
        }
        this.scannerId = null;
        this.sequenceId = 0;
        this.lastPrimaryKey = AsyncKuduClient.EMPTY_ARRAY;
        this.invalidate();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Deferred<RowResultIterator> close() {
        if (this.closed) {
            return Deferred.fromResult(null);
        }
        return this.client.closeScanner(this).addCallback(this.closedCallback());
    }

    private Callback<RowResultIterator, Response> closedCallback() {
        return new Callback<RowResultIterator, Response>(){

            @Override
            public RowResultIterator call(Response response) {
                AsyncKuduScanner.this.closed = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner {} closed on {}", (Object)Bytes.pretty(AsyncKuduScanner.this.scannerId), (Object)AsyncKuduScanner.this.tablet);
                }
                AsyncKuduScanner.this.invalidate();
                AsyncKuduScanner.access$1402(AsyncKuduScanner.this, "client debug closed".getBytes(StandardCharsets.UTF_8));
                return response == null ? null : response.data;
            }

            public String toString() {
                return "scanner closed";
            }
        };
    }

    public String toString() {
        String tablet = this.tablet == null ? "null" : this.tablet.getTabletId();
        StringBuilder buf = new StringBuilder();
        buf.append("KuduScanner(table=");
        buf.append(this.table.getName());
        buf.append(", tablet=").append(tablet);
        buf.append(", scannerId=").append(Bytes.pretty(this.scannerId));
        buf.append(", scanRequestTimeout=").append(this.scanRequestTimeout);
        if (this.startPrimaryKey.length > 0) {
            buf.append(", startPrimaryKey=").append(Bytes.hex(this.startPrimaryKey));
        } else {
            buf.append(", startPrimaryKey=<start>");
        }
        if (this.endPrimaryKey.length > 0) {
            buf.append(", endPrimaryKey=").append(Bytes.hex(this.endPrimaryKey));
        } else {
            buf.append(", endPrimaryKey=<end>");
        }
        if (this.lastPrimaryKey.length > 0) {
            buf.append(", lastPrimaryKey=").append(Bytes.hex(this.lastPrimaryKey));
        } else {
            buf.append(", lastPrimaryKey=<last>");
        }
        buf.append(')');
        return buf.toString();
    }

    KuduTable table() {
        return this.table;
    }

    void invalidate() {
        this.tablet = null;
    }

    RemoteTablet currentTablet() {
        return this.tablet;
    }

    ReplicaSelection getReplicaSelection() {
        return this.replicaSelection;
    }

    KuduRpc<Response> getOpenRequest() {
        this.checkScanningNotStarted();
        return new ScanRequest(this.table, State.OPENING, this.tablet);
    }

    public Deferred<Void> keepAlive() {
        if (this.closed) {
            if (this.prefetching && this.cachedPrefetcherDeferred.get() != null) {
                return Deferred.fromResult(null);
            }
            throw new IllegalStateException("Scanner has already been closed");
        }
        return this.client.keepAlive(this);
    }

    KuduRpc<Response> getNextRowsRequest() {
        return new ScanRequest(this.table, State.NEXT, this.tablet);
    }

    KuduRpc<Response> getCloseRequest() {
        return new ScanRequest(this.table, State.CLOSING, this.tablet);
    }

    KuduRpc<Void> getKeepAliveRequest() {
        return new KeepAliveRequest(this.table, this.tablet);
    }

    private void checkScanningNotStarted() {
        if (this.tablet != null) {
            throw new IllegalStateException("scanning already started");
        }
    }

    static /* synthetic */ byte[] access$702(AsyncKuduScanner x0, byte[] x1) {
        x0.lastPrimaryKey = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1402(AsyncKuduScanner x0, byte[] x1) {
        x0.scannerId = x1;
        return x1;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class AsyncKuduScannerBuilder
    extends AbstractKuduScannerBuilder<AsyncKuduScannerBuilder, AsyncKuduScanner> {
        AsyncKuduScannerBuilder(AsyncKuduClient client, KuduTable table) {
            super(client, table);
        }

        @Override
        public AsyncKuduScanner build() {
            return new AsyncKuduScanner(this.client, this.table, this.projectedColumnNames, this.projectedColumnIndexes, this.readMode, this.isFaultTolerant, this.scanRequestTimeout, this.predicates, this.limit, this.cacheBlocks, this.prefetching, this.lowerBoundPrimaryKey, this.upperBoundPrimaryKey, this.startTimestamp, this.htTimestamp, this.batchSizeBytes, PartitionPruner.create(this), this.replicaSelection, this.keepAlivePeriodMs);
        }
    }

    final class ScanRequest
    extends KuduRpc<Response> {
        private final State state;
        private Token.SignedTokenPB authzToken;

        ScanRequest(KuduTable table, State state, RemoteTablet tablet) {
            super(table, AsyncKuduScanner.this.client.getTimer(), AsyncKuduScanner.this.scanRequestTimeout);
            this.setTablet(tablet);
            this.state = state;
        }

        @Override
        String serviceName() {
            return "kudu.tserver.TabletServerService";
        }

        @Override
        String method() {
            return "Scan";
        }

        @Override
        Collection<Integer> getRequiredFeatures() {
            if (AsyncKuduScanner.this.predicates.isEmpty()) {
                return ImmutableList.of();
            }
            return ImmutableList.of(Integer.valueOf(1));
        }

        @Override
        ReplicaSelection getReplicaSelection() {
            return AsyncKuduScanner.this.replicaSelection;
        }

        @Override
        boolean needsAuthzToken() {
            return true;
        }

        @Override
        void bindAuthzToken(Token.SignedTokenPB token) {
            this.authzToken = token;
        }

        @Override
        Message createRequestPB() {
            Tserver.ScanRequestPB.Builder builder = Tserver.ScanRequestPB.newBuilder();
            switch (this.state) {
                case OPENING: {
                    AsyncKuduScanner.this.tablet = super.getTablet();
                    Tserver.NewScanRequestPB.Builder newBuilder = Tserver.NewScanRequestPB.newBuilder();
                    newBuilder.setLimit(AsyncKuduScanner.this.limit - AsyncKuduScanner.this.numRowsReturned);
                    newBuilder.addAllProjectedColumns(ProtobufHelper.schemaToListPb(AsyncKuduScanner.this.schema));
                    newBuilder.setTabletId(UnsafeByteOperations.unsafeWrap(AsyncKuduScanner.this.tablet.getTabletIdAsBytes()));
                    newBuilder.setOrderMode(AsyncKuduScanner.this.getOrderMode());
                    newBuilder.setCacheBlocks(AsyncKuduScanner.this.cacheBlocks);
                    long rowFormatFlags = 0L;
                    if (AsyncKuduScanner.this.rowDataFormat == RowDataFormat.COLUMNAR) {
                        rowFormatFlags |= (long)Tserver.RowFormatFlags.COLUMNAR_LAYOUT.getNumber();
                    }
                    newBuilder.setRowFormatFlags(rowFormatFlags);
                    long timestamp = AsyncKuduScanner.this.readMode == ReadMode.READ_YOUR_WRITES ? AsyncKuduScanner.this.lowerBoundPropagationTimestamp : this.table.getAsyncClient().getLastPropagatedTimestamp();
                    if (timestamp != -1L) {
                        newBuilder.setPropagatedTimestamp(timestamp);
                    }
                    newBuilder.setReadMode(AsyncKuduScanner.this.getReadMode().pbVersion());
                    if (AsyncKuduScanner.this.getReadMode() == ReadMode.READ_AT_SNAPSHOT) {
                        if (AsyncKuduScanner.this.getSnapshotTimestamp() != -1L) {
                            newBuilder.setSnapTimestamp(AsyncKuduScanner.this.getSnapshotTimestamp());
                        }
                        if (AsyncKuduScanner.this.getStartSnapshotTimestamp() != -1L) {
                            newBuilder.setSnapStartTimestamp(AsyncKuduScanner.this.getStartSnapshotTimestamp());
                        }
                    }
                    if (AsyncKuduScanner.this.isFaultTolerant && AsyncKuduScanner.this.lastPrimaryKey.length > 0) {
                        newBuilder.setLastPrimaryKey(UnsafeByteOperations.unsafeWrap(AsyncKuduScanner.this.lastPrimaryKey));
                    }
                    if (AsyncKuduScanner.this.startPrimaryKey.length > 0) {
                        newBuilder.setStartPrimaryKey(UnsafeByteOperations.unsafeWrap(AsyncKuduScanner.this.startPrimaryKey));
                    }
                    if (AsyncKuduScanner.this.endPrimaryKey.length > 0) {
                        newBuilder.setStopPrimaryKey(UnsafeByteOperations.unsafeWrap(AsyncKuduScanner.this.endPrimaryKey));
                    }
                    for (KuduPredicate pred : AsyncKuduScanner.this.predicates.values()) {
                        newBuilder.addColumnPredicates(pred.toPB());
                    }
                    if (this.authzToken != null) {
                        newBuilder.setAuthzToken(this.authzToken);
                    }
                    builder.setNewScanRequest(newBuilder.build()).setBatchSizeBytes(AsyncKuduScanner.this.batchSizeBytes);
                    break;
                }
                case NEXT: {
                    builder.setScannerId(UnsafeByteOperations.unsafeWrap(AsyncKuduScanner.this.scannerId)).setCallSeqId(AsyncKuduScanner.this.sequenceId).setBatchSizeBytes(AsyncKuduScanner.this.batchSizeBytes);
                    break;
                }
                case CLOSING: {
                    builder.setScannerId(UnsafeByteOperations.unsafeWrap(AsyncKuduScanner.this.scannerId)).setBatchSizeBytes(0).setCloseScanner(true);
                    break;
                }
                default: {
                    throw new RuntimeException("unreachable!");
                }
            }
            return builder.build();
        }

        @Override
        Pair<Response, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
            Tserver.TabletServerErrorPB error;
            Tserver.ScanResponsePB.Builder builder = Tserver.ScanResponsePB.newBuilder();
            ScanRequest.readProtobuf(callResponse.getPBMessage(), builder);
            Tserver.ScanResponsePB resp = builder.build();
            byte[] id = resp.getScannerId().toByteArray();
            Tserver.TabletServerErrorPB tabletServerErrorPB = error = resp.hasError() ? resp.getError() : null;
            if (error != null) {
                if (AsyncKuduScanner.this.canBeIgnored(resp.getError().getCode())) {
                    LOG.info("Ignore false alert of scanner not found for scan request");
                    error = null;
                } else {
                    switch (error.getCode()) {
                        case TABLET_NOT_FOUND: 
                        case TABLET_NOT_RUNNING: {
                            if (this.state == State.OPENING || this.state == State.NEXT && AsyncKuduScanner.this.isFaultTolerant) {
                                return new Pair<Object, Tserver.TabletServerErrorPB>(null, error);
                            }
                            Status statusIncomplete = Status.Incomplete("Cannot continue scanning, the tablet has moved and this isn't a fault tolerant scan");
                            throw new NonRecoverableException(statusIncomplete);
                        }
                        case SCANNER_EXPIRED: {
                            if (!AsyncKuduScanner.this.isFaultTolerant) break;
                            Status status = Status.fromTabletServerErrorPB(error);
                            throw new FaultTolerantScannerExpiredException(status);
                        }
                    }
                }
            }
            RowResultIterator iterator = resp.hasData() ? RowwiseRowResultIterator.makeRowResultIterator(this.timeoutTracker.getElapsedMillis(), tsUUID, AsyncKuduScanner.this.schema, resp.getData(), callResponse, AsyncKuduScanner.this.reuseRowResult) : ColumnarRowResultIterator.makeRowResultIterator(this.timeoutTracker.getElapsedMillis(), tsUUID, AsyncKuduScanner.this.schema, resp.getColumnarData(), callResponse, AsyncKuduScanner.this.reuseRowResult);
            boolean hasMore = resp.getHasMoreResults();
            if (id.length != 0 && AsyncKuduScanner.this.scannerId != null && !Bytes.equals(AsyncKuduScanner.this.scannerId, id)) {
                Status statusIllegalState = Status.IllegalState("Scan RPC response was for scanner ID " + Bytes.pretty(id) + " but we expected " + Bytes.pretty(AsyncKuduScanner.this.scannerId));
                throw new NonRecoverableException(statusIllegalState);
            }
            Tserver.ResourceMetricsPB resourceMetricsPB = resp.hasResourceMetrics() ? resp.getResourceMetrics() : null;
            Response response = new Response(id, iterator, hasMore, resp.hasSnapTimestamp() ? resp.getSnapTimestamp() : -1L, resp.hasPropagatedTimestamp() ? resp.getPropagatedTimestamp() : -1L, resp.getLastPrimaryKey().toByteArray(), resourceMetricsPB);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} for scanner {}", (Object)response, (Object)AsyncKuduScanner.this);
            }
            return new Pair<Response, Object>(response, error);
        }

        @Override
        public String toString() {
            return "ScanRequest(scannerId=" + Bytes.pretty(AsyncKuduScanner.this.scannerId) + ", state=" + (Object)((Object)this.state) + (AsyncKuduScanner.this.tablet != null ? ", tablet=" + AsyncKuduScanner.this.tablet.getTabletId() : "") + ", attempt=" + this.attempt + ", " + super.toString() + ")";
        }

        @Override
        public byte[] partitionKey() {
            return AsyncKuduScanner.this.pruner.nextPartitionKey();
        }
    }

    final class KeepAliveRequest
    extends KuduRpc<Void> {
        KeepAliveRequest(KuduTable table, RemoteTablet tablet) {
            super(table, AsyncKuduScanner.this.client.getTimer(), AsyncKuduScanner.this.scanRequestTimeout);
            this.setTablet(tablet);
        }

        @Override
        String serviceName() {
            return "kudu.tserver.TabletServerService";
        }

        @Override
        String method() {
            return "ScannerKeepAlive";
        }

        @Override
        ReplicaSelection getReplicaSelection() {
            return AsyncKuduScanner.this.replicaSelection;
        }

        @Override
        Message createRequestPB() {
            Tserver.ScannerKeepAliveRequestPB.Builder builder = Tserver.ScannerKeepAliveRequestPB.newBuilder();
            builder.setScannerId(UnsafeByteOperations.unsafeWrap(AsyncKuduScanner.this.scannerId));
            return builder.build();
        }

        @Override
        public byte[] partitionKey() {
            return AsyncKuduScanner.this.pruner.nextPartitionKey();
        }

        @Override
        Pair<Void, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
            Tserver.ScannerKeepAliveResponsePB.Builder builder = Tserver.ScannerKeepAliveResponsePB.newBuilder();
            KeepAliveRequest.readProtobuf(callResponse.getPBMessage(), builder);
            Tserver.ScannerKeepAliveResponsePB resp = builder.build();
            Tserver.TabletServerErrorPB error = null;
            if (resp.hasError()) {
                if (AsyncKuduScanner.this.canBeIgnored(resp.getError().getCode())) {
                    LOG.info("Ignore false alert of scanner not found for keep alive request");
                } else {
                    error = resp.getError();
                }
            }
            return new Pair<Object, Object>(null, error);
        }
    }

    private static enum State {
        OPENING,
        NEXT,
        CLOSING;

    }

    static final class Response {
        private final byte[] scannerId;
        private final RowResultIterator data;
        private final boolean more;
        private final long scanTimestamp;
        private final long propagatedTimestamp;
        private final byte[] lastPrimaryKey;
        private final Tserver.ResourceMetricsPB resourceMetricsPb;

        Response(byte[] scannerId, RowResultIterator data, boolean more, long scanTimestamp, long propagatedTimestamp, byte[] lastPrimaryKey, Tserver.ResourceMetricsPB resourceMetricsPb) {
            this.scannerId = scannerId;
            this.data = data;
            this.more = more;
            this.scanTimestamp = scanTimestamp;
            this.propagatedTimestamp = propagatedTimestamp;
            this.lastPrimaryKey = lastPrimaryKey;
            this.resourceMetricsPb = resourceMetricsPb;
        }

        public String toString() {
            String ret = "AsyncKuduScanner$Response(scannerId = " + Bytes.pretty(this.scannerId) + ", data = " + this.data + ", more = " + this.more;
            if (this.scanTimestamp != -1L) {
                ret = ret + ", responseScanTimestamp = " + this.scanTimestamp;
            }
            ret = ret + ")";
            return ret;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum RowDataFormat {
        ROWWISE,
        COLUMNAR;

    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum ReadMode {
        READ_LATEST(Common.ReadMode.READ_LATEST),
        READ_AT_SNAPSHOT(Common.ReadMode.READ_AT_SNAPSHOT),
        READ_YOUR_WRITES(Common.ReadMode.READ_YOUR_WRITES);

        private final Common.ReadMode pbVersion;

        private ReadMode(Common.ReadMode pbVersion) {
            this.pbVersion = pbVersion;
        }

        @InterfaceAudience.Private
        public Common.ReadMode pbVersion() {
            return this.pbVersion;
        }
    }
}

