/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.entities;

public class CompactionMetricsData {
    private final String dbName;
    private final String tblName;
    private final String partitionName;
    private final MetricType metricType;
    private final int metricValue;
    private final int version;
    private final int threshold;

    private CompactionMetricsData(Builder builder) {
        this.dbName = builder.dbName;
        this.tblName = builder.tblName;
        this.partitionName = builder.partitionName;
        this.metricType = builder.metricType;
        this.metricValue = builder.metricValue;
        this.version = builder.version;
        this.threshold = builder.threshold;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTblName() {
        return this.tblName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public int getMetricValue() {
        return this.metricValue;
    }

    public int getVersion() {
        return this.version;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isEmpty() {
        return this.dbName == null && this.tblName == null && this.partitionName == null && this.metricType == null && this.metricValue == 0 && this.version == 0;
    }

    public String toString() {
        return "DeltaMetricsInfo{dbName='" + this.dbName + "', tblName='" + this.tblName + "', partitionName='" + this.partitionName + "', metricType=" + String.valueOf((Object)this.metricType) + ", metricValue=" + this.metricValue + ", version=" + this.version + "}";
    }

    public static class Builder {
        private String dbName;
        private String tblName;
        private String partitionName;
        private MetricType metricType;
        private int metricValue;
        private int version;
        private int threshold;

        public CompactionMetricsData build() {
            return new CompactionMetricsData(this);
        }

        public Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public Builder tblName(String tblName) {
            this.tblName = tblName;
            return this;
        }

        public Builder partitionName(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        public Builder metricType(MetricType metricType) {
            this.metricType = metricType;
            return this;
        }

        public Builder metricValue(int metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }
    }

    public static enum MetricType {
        NUM_OBSOLETE_DELTAS("HIVE_ACID_NUM_OBSOLETE_DELTAS"),
        NUM_DELTAS("HIVE_ACID_NUM_DELTAS"),
        NUM_SMALL_DELTAS("HIVE_ACID_NUM_SMALL_DELTAS");

        private final String value;

        private MetricType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

