/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.jdbc.authentication.BasicAuthenticationServiceImpl;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class CreateRoleConstantAction
extends DDLConstantAction {
    private String roleName;

    public CreateRoleConstantAction(String string) {
        this.roleName = string;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (this.roleName.equals("PUBLIC")) {
            throw StandardException.newException((String)"4251B", (Object[])new Object[0]);
        }
        String string = languageConnectionContext.getCurrentUserId(activation);
        dataDictionary.startWriting(languageConnectionContext);
        RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(this.roleName);
        if (roleGrantDescriptor != null) {
            throw StandardException.newException((String)"X0Y68.S", (Object[])new Object[]{roleGrantDescriptor.getDescriptorType(), this.roleName});
        }
        if (this.knownUser(this.roleName, string, languageConnectionContext, dataDictionary, transactionController)) {
            throw StandardException.newException((String)"X0Y68.S", (Object[])new Object[]{"User", this.roleName});
        }
        roleGrantDescriptor = dataDescriptorGenerator.newRoleGrantDescriptor(dataDictionary.getUUIDFactory().createUUID(), this.roleName, string, "_SYSTEM", true, true);
        dataDictionary.addDescriptor(roleGrantDescriptor, null, 19, false, transactionController);
    }

    public String toString() {
        return "CREATE ROLE " + this.roleName;
    }

    private boolean knownUser(String string, String string2, LanguageConnectionContext languageConnectionContext, DataDictionary dataDictionary, TransactionController transactionController) throws StandardException {
        AuthenticationService authenticationService = languageConnectionContext.getDatabase().getAuthenticationService();
        if (string2.equals(string)) {
            return true;
        }
        if (authenticationService instanceof BasicAuthenticationServiceImpl && PropertyUtil.existsBuiltinUser(transactionController, string)) {
            return true;
        }
        if (dataDictionary.existsGrantToAuthid(string, transactionController)) {
            return true;
        }
        return dataDictionary.existsSchemaOwnedBy(string, transactionController);
    }
}

