/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;

interface ManifestEntry<F extends ContentFile<F>> {
    public static final Types.NestedField STATUS = Types.NestedField.required(0, "status", Types.IntegerType.get());
    public static final Types.NestedField SNAPSHOT_ID = Types.NestedField.optional(1, "snapshot_id", Types.LongType.get());
    public static final Types.NestedField SEQUENCE_NUMBER = Types.NestedField.optional(3, "sequence_number", Types.LongType.get());
    public static final Types.NestedField FILE_SEQUENCE_NUMBER = Types.NestedField.optional(4, "file_sequence_number", Types.LongType.get());
    public static final int DATA_FILE_ID = 2;

    public static Schema getSchema(Types.StructType partitionType) {
        return ManifestEntry.wrapFileSchema(DataFile.getType(partitionType));
    }

    public static Schema wrapFileSchema(Types.StructType fileType) {
        return new Schema(STATUS, SNAPSHOT_ID, SEQUENCE_NUMBER, FILE_SEQUENCE_NUMBER, Types.NestedField.required(2, "data_file", fileType));
    }

    public Status status();

    default public boolean isLive() {
        return this.status() == Status.ADDED || this.status() == Status.EXISTING;
    }

    public Long snapshotId();

    public void setSnapshotId(long var1);

    public Long dataSequenceNumber();

    public void setDataSequenceNumber(long var1);

    public Long fileSequenceNumber();

    public void setFileSequenceNumber(long var1);

    public F file();

    public ManifestEntry<F> copy();

    public ManifestEntry<F> copyWithoutStats();

    public static enum Status {
        EXISTING(0),
        ADDED(1),
        DELETED(2);

        private final int id;

        private Status(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

