/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.AccumuloIndexScanner;
import org.apache.hadoop.hive.accumulo.serde.AccumuloIndexParameters;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloDefaultIndexScanner
implements AccumuloIndexScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AccumuloDefaultIndexScanner.class);
    private AccumuloConnectionParameters connectParams;
    private AccumuloIndexParameters indexParams;
    private int maxRowIds;
    private Authorizations auths;
    private String indexTable;
    private Set<String> indexColumns = Collections.EMPTY_SET;
    private Connector connect;
    private Map<String, String> colMap;

    @Override
    public void init(Configuration conf) {
        this.connectParams = new AccumuloConnectionParameters(conf);
        this.indexParams = new AccumuloIndexParameters(conf);
        this.maxRowIds = this.indexParams.getMaxIndexRows();
        this.auths = this.indexParams.getTableAuths();
        this.indexTable = this.indexParams.getIndexTable();
        this.indexColumns = this.indexParams.getIndexColumns();
        this.colMap = this.createColumnMap(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Range> getIndexRowRanges(String column, Range indexRange) {
        ArrayList<Range> rowIds = new ArrayList<Range>();
        Scanner scan = null;
        String col = this.colMap.get(column);
        if (col != null) {
            try {
                LOG.debug("Searching tab=" + this.indexTable + " column=" + column + " range=" + String.valueOf(indexRange));
                Connector conn = this.getConnector();
                scan = conn.createScanner(this.indexTable, this.auths);
                scan.setRange(indexRange);
                Text cf = new Text(col);
                LOG.debug("Using Column Family=" + this.toString());
                scan.fetchColumnFamily(cf);
                for (Map.Entry entry : scan) {
                    rowIds.add(new Range(((Key)entry.getKey()).getColumnQualifier()));
                    if (rowIds.size() <= this.maxRowIds) continue;
                    List<Range> list = null;
                    return list;
                }
                if (rowIds.isEmpty()) {
                    LOG.debug("Found 0 index matches");
                } else {
                    LOG.debug("Found " + rowIds.size() + " index matches");
                }
                ArrayList<Range> arrayList = rowIds;
                return arrayList;
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
                LOG.error("Failed to scan index table: " + this.indexTable, e);
            }
            finally {
                if (scan != null) {
                    scan.close();
                }
            }
        }
        LOG.debug("Index lookup failed for table " + this.indexTable);
        return null;
    }

    @Override
    public boolean isIndexed(String column) {
        return this.indexTable != null && (this.indexColumns.isEmpty() || this.indexColumns.contains("*") || this.indexColumns.contains(column.toLowerCase()) || this.indexColumns.contains(column.toUpperCase()));
    }

    protected Map<String, String> createColumnMap(Configuration conf) {
        HashMap<String, String> colsMap = new HashMap<String, String>();
        String accColString = conf.get("accumulo.columns.mapping");
        if (accColString != null && !accColString.trim().isEmpty()) {
            String[] accCols = accColString.split(",");
            String[] hiveCols = conf.get("columns").split(",");
            for (int i = 0; i < accCols.length; ++i) {
                colsMap.put(hiveCols[i], accCols[i].replace(':', '_'));
            }
        }
        return colsMap;
    }

    protected Connector getConnector() throws AccumuloSecurityException, AccumuloException {
        if (this.connect == null) {
            this.connect = this.connectParams.getConnector();
        }
        return this.connect;
    }

    public void setConnectParams(AccumuloConnectionParameters connectParams) {
        this.connectParams = connectParams;
    }

    public AccumuloConnectionParameters getConnectParams() {
        return this.connectParams;
    }

    public AccumuloIndexParameters getIndexParams() {
        return this.indexParams;
    }

    public int getMaxRowIds() {
        return this.maxRowIds;
    }

    public Authorizations getAuths() {
        return this.auths;
    }

    public String getIndexTable() {
        return this.indexTable;
    }

    public Set<String> getIndexColumns() {
        return this.indexColumns;
    }

    public Connector getConnect() {
        return this.connect;
    }
}

