/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.glossary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.atlas.model.AtlasBaseModelObject;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.commons.collections.CollectionUtils;

public abstract class AtlasGlossaryBaseObject
extends AtlasBaseModelObject {
    private String qualifiedName;
    protected String name;
    protected String shortDescription;
    protected String longDescription;
    private Map<String, Object> additionalAttributes;
    protected List<AtlasClassification> classifications;

    public AtlasGlossaryBaseObject() {
    }

    public AtlasGlossaryBaseObject(AtlasGlossaryBaseObject other) {
        super(other);
        this.name = other.name;
        this.shortDescription = other.shortDescription;
        this.longDescription = other.longDescription;
        this.classifications = other.classifications;
        this.qualifiedName = other.qualifiedName;
        this.additionalAttributes = other.additionalAttributes;
    }

    public Map<String, Object> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void setAdditionalAttributes(Map<String, Object> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public abstract void setAttribute(String var1, String var2);

    public List<AtlasClassification> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<AtlasClassification> classifications) {
        this.classifications = classifications;
    }

    @JsonIgnore
    public void addClassification(AtlasClassification classification) {
        List<AtlasClassification> classifications = this.classifications;
        if (classifications == null) {
            classifications = new ArrayList<AtlasClassification>();
        }
        classifications.add(classification);
        this.setClassifications(classifications);
    }

    @JsonIgnore
    public void removeClassification(AtlasClassification classification) {
        if (CollectionUtils.isNotEmpty(this.classifications)) {
            this.classifications.remove(classification);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasGlossaryBaseObject that = (AtlasGlossaryBaseObject)o;
        return Objects.equals(this.qualifiedName, that.qualifiedName) && Objects.equals(this.name, that.name) && Objects.equals(this.shortDescription, that.shortDescription) && Objects.equals(this.longDescription, that.longDescription) && Objects.equals(this.additionalAttributes, that.additionalAttributes) && Objects.equals(this.classifications, that.classifications);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.qualifiedName, this.name, this.shortDescription, this.longDescription, this.additionalAttributes, this.classifications);
    }

    @Override
    protected StringBuilder toString(StringBuilder sb) {
        sb.append(", qualifiedName='").append(this.qualifiedName).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", shortDescription='").append(this.shortDescription).append('\'');
        sb.append(", longDescription='").append(this.longDescription).append('\'');
        sb.append(", classifications=").append(this.classifications).append('\'');
        sb.append(", additionalAttributes=").append(this.additionalAttributes);
        return sb;
    }
}

