/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class MessageSource {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSource.class);
    private static final String BUILDINFO_PROPERTIES = "/atlas-buildinfo.properties";
    private static final String BUILD_VERSION_PROPERTY_KEY = "build.version";
    private static final String BUILD_VERSION_DEFAULT = "UNKNOWN";
    private static String storedVersion = MessageSource.fetchBuildVersion();
    private String name;
    private String version;

    public MessageSource() {
    }

    public MessageSource(String name) {
        this.version = storedVersion;
        this.name = name;
    }

    public String getSource() {
        return this.name;
    }

    public void setSource(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    private static String fetchBuildVersion() {
        Properties properties = new Properties();
        InputStream inputStream = MessageSource.class.getResourceAsStream(BUILDINFO_PROPERTIES);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            properties.load(inputStreamReader);
        }
        catch (IOException e) {
            LOG.error("Failed to load atlas-buildinfo properties. Will use default version.", (Throwable)e);
        }
        return properties.getProperty(BUILD_VERSION_PROPERTY_KEY, BUILD_VERSION_DEFAULT);
    }
}

