/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.janino;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.janino.JaninoData;
import org.apache.hop.pipeline.transforms.janino.JaninoMeta;
import org.apache.hop.pipeline.transforms.janino.JaninoMetaFunction;
import org.apache.hop.pipeline.transforms.janino.function.FunctionLib;
import org.apache.hop.pipeline.transforms.util.JaninoCheckerUtil;
import org.codehaus.janino.ExpressionEvaluator;

public class Janino
extends BaseTransform<JaninoMeta, JaninoData> {
    private static final Class<?> PKG = JaninoMeta.class;

    public Janino(TransformMeta transformMeta, JaninoMeta meta, JaninoData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((JaninoData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((JaninoMeta)this.meta).getFields(((JaninoData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((JaninoData)this.data).replaceIndex = new int[((JaninoMeta)this.meta).getFormula().length];
            ((JaninoData)this.data).returnType = new IValueMeta[((JaninoMeta)this.meta).getFormula().length];
            for (int i = 0; i < ((JaninoMeta)this.meta).getFormula().length; ++i) {
                JaninoMetaFunction fn = ((JaninoMeta)this.meta).getFormula()[i];
                ((JaninoData)this.data).returnType[i] = ValueMetaFactory.createValueMeta((int)fn.getValueType());
                if (!Utils.isEmpty((CharSequence)fn.getReplaceField())) {
                    ((JaninoData)this.data).replaceIndex[i] = this.getInputRowMeta().indexOfValue(fn.getReplaceField());
                    if (((JaninoData)this.data).replaceIndex[i] >= 0) continue;
                    throw new HopException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
                }
                ((JaninoData)this.data).replaceIndex[i] = -1;
            }
        }
        if (this.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            Object[] outputRowData = this.calcFields(this.getInputRowMeta(), r);
            this.putRow(((JaninoData)this.data).outputRowMeta, outputRowData);
            if (this.isRowLevel()) {
                this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + ((JaninoData)this.data).outputRowMeta.getString(outputRowData));
            }
        }
        catch (Exception e) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.toString(), null, "UJE001");
            }
            throw new HopException((Throwable)e);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] calcFields(IRowMeta rowMeta, Object[] r) throws HopValueException {
        try {
            IValueMeta valueMeta;
            int i;
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)((JaninoData)this.data).outputRowMeta.size());
            int tempIndex = rowMeta.size();
            if (((JaninoData)this.data).expressionEvaluators == null) {
                List<Object> argIndexes;
                ((JaninoData)this.data).expressionEvaluators = new ExpressionEvaluator[((JaninoMeta)this.meta).getFormula().length];
                ((JaninoData)this.data).argumentIndexes = new ArrayList<List<Integer>>();
                for (i = 0; i < ((JaninoMeta)this.meta).getFormula().length; ++i) {
                    argIndexes = new ArrayList();
                    ((JaninoData)this.data).argumentIndexes.add(argIndexes);
                }
                for (int m = 0; m < ((JaninoMeta)this.meta).getFormula().length; ++m) {
                    argIndexes = ((JaninoData)this.data).argumentIndexes.get(m);
                    ArrayList<String> parameterNames = new ArrayList<String>();
                    ArrayList<Class> parameterTypes = new ArrayList<Class>();
                    for (int i2 = 0; i2 < ((JaninoData)this.data).outputRowMeta.size(); ++i2) {
                        valueMeta = ((JaninoData)this.data).outputRowMeta.getValueMeta(i2);
                        if (!((JaninoMeta)this.meta).getFormula()[m].getFormula().contains(valueMeta.getName())) continue;
                        argIndexes.add(i2);
                        parameterTypes.add(valueMeta.getNativeDataTypeClass());
                        parameterNames.add(valueMeta.getName());
                    }
                    JaninoMetaFunction fn = ((JaninoMeta)this.meta).getFormula()[m];
                    if (Utils.isEmpty((CharSequence)fn.getFieldName())) throw new HopException("Unable to find field name for formula [" + (!StringUtil.isEmpty((String)fn.getFormula()) ? fn.getFormula() : "") + "]");
                    PluginRegistry registry = PluginRegistry.getInstance();
                    IPlugin plugin = registry.getPlugin(TransformPluginType.class, "Janino");
                    ClassLoader loader = registry.getClassLoader(plugin);
                    FunctionLib functionLib = new FunctionLib();
                    ((JaninoData)this.data).expressionEvaluators[m] = new ExpressionEvaluator();
                    ((JaninoData)this.data).expressionEvaluators[m].setParameters(parameterNames.toArray(new String[parameterNames.size()]), parameterTypes.toArray(new Class[parameterTypes.size()]));
                    ((JaninoData)this.data).expressionEvaluators[m].setReturnType(Object.class);
                    ((JaninoData)this.data).expressionEvaluators[m].setThrownExceptions(new Class[]{Exception.class});
                    ((JaninoData)this.data).expressionEvaluators[m].setParentClassLoader(loader);
                    ((JaninoData)this.data).expressionEvaluators[m].setDefaultImports(functionLib.getImportPackages());
                    JaninoCheckerUtil janinoCheckerUtil = new JaninoCheckerUtil();
                    List<String> codeCheck = janinoCheckerUtil.checkCode(fn.getFormula());
                    if (!codeCheck.isEmpty()) {
                        throw new HopException("Script contains code that is not allowed : " + String.valueOf(codeCheck));
                    }
                    ((JaninoData)this.data).expressionEvaluators[m].cook(fn.getFormula());
                }
            }
            for (i = 0; i < ((JaninoMeta)this.meta).getFormula().length; ++i) {
                List<Integer> argumentIndexes = ((JaninoData)this.data).argumentIndexes.get(i);
                Object[] argumentData = new Object[argumentIndexes.size()];
                for (int x = 0; x < argumentIndexes.size(); ++x) {
                    int index = argumentIndexes.get(x);
                    IValueMeta outputValueMeta = ((JaninoData)this.data).outputRowMeta.getValueMeta(index);
                    argumentData[x] = outputValueMeta.convertToNormalStorageType(outputRowData[index]);
                }
                Object formulaResult = ((JaninoData)this.data).expressionEvaluators[i].evaluate(argumentData);
                Object value = null;
                if (formulaResult == null) {
                    value = null;
                } else {
                    valueMeta = ((JaninoData)this.data).returnType[i];
                    if (valueMeta.getNativeDataTypeClass().isAssignableFrom(formulaResult.getClass())) {
                        value = formulaResult;
                    } else {
                        if (!(formulaResult instanceof Integer)) throw new HopValueException(BaseMessages.getString(PKG, (String)"Janino.Error.ValueTypeMismatch", (Object[])new Object[]{valueMeta.getTypeDesc(), ((JaninoMeta)this.meta).getFormula()[i].getFieldName(), formulaResult.getClass(), ((JaninoMeta)this.meta).getFormula()[i].getFormula()}));
                        Integer integer = (Integer)formulaResult;
                        if (valueMeta.getType() != 5) throw new HopValueException(BaseMessages.getString(PKG, (String)"Janino.Error.ValueTypeMismatch", (Object[])new Object[]{valueMeta.getTypeDesc(), ((JaninoMeta)this.meta).getFormula()[i].getFieldName(), formulaResult.getClass(), ((JaninoMeta)this.meta).getFormula()[i].getFormula()}));
                        value = integer.longValue();
                    }
                }
                if (((JaninoData)this.data).replaceIndex[i] < 0) {
                    outputRowData[tempIndex++] = value;
                    continue;
                }
                outputRowData[((JaninoData)this.data).replaceIndex[i]] = value;
            }
            return outputRowData;
        }
        catch (Exception e) {
            throw new HopValueException((Throwable)e);
        }
    }

    public boolean init() {
        return super.init();
    }
}

