/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmUserEntry
implements Serializable,
Comparable {
    private static final long serialVersionUID = -3021438367015187166L;
    private OctetString engineID;
    private OctetString userName;
    private UsmUser usmUser;
    private byte[] authenticationKey;
    private byte[] privacyKey;

    public UsmUserEntry() {
        this.engineID = new OctetString();
        this.userName = new OctetString();
        this.usmUser = new UsmUser(new OctetString(), null, null, null, null);
    }

    public UsmUserEntry(OctetString octetString, UsmUser usmUser) {
        this.userName = octetString;
        this.usmUser = usmUser;
        if (usmUser.isLocalized() && usmUser.getAuthenticationProtocol() != null && usmUser.getAuthenticationPassphrase() != null) {
            this.authenticationKey = usmUser.getAuthenticationPassphrase().getValue();
            if (usmUser.getPrivacyProtocol() != null && usmUser.getPrivacyPassphrase() != null) {
                this.privacyKey = usmUser.getPrivacyPassphrase().getValue();
            }
        }
    }

    public UsmUserEntry(OctetString octetString, OctetString octetString2, UsmUser usmUser) {
        this(octetString, usmUser);
        this.engineID = octetString2;
    }

    public UsmUserEntry(byte[] byArray, OctetString octetString, OID oID, byte[] byArray2, OID oID2, byte[] byArray3) {
        this.engineID = byArray == null ? null : new OctetString(byArray);
        this.userName = octetString;
        this.authenticationKey = byArray2;
        this.privacyKey = byArray3;
        this.usmUser = new UsmUser(this.userName, oID, this.authenticationKey != null ? new OctetString(this.authenticationKey) : null, oID2, this.privacyKey != null ? new OctetString(this.privacyKey) : null, this.engineID);
    }

    public OctetString getEngineID() {
        return this.engineID;
    }

    public void setEngineID(OctetString octetString) {
        this.engineID = octetString;
    }

    public void setUserName(OctetString octetString) {
        this.userName = octetString;
    }

    public OctetString getUserName() {
        return this.userName;
    }

    public void setUsmUser(UsmUser usmUser) {
        this.usmUser = usmUser;
    }

    public UsmUser getUsmUser() {
        return this.usmUser;
    }

    public void setAuthenticationKey(byte[] byArray) {
        this.authenticationKey = byArray;
    }

    public byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setPrivacyKey(byte[] byArray) {
        this.privacyKey = byArray;
    }

    public byte[] getPrivacyKey() {
        return this.privacyKey;
    }

    public int compareTo(Object object) {
        UsmUserEntry usmUserEntry = (UsmUserEntry)object;
        int n = 0;
        if (this.engineID != null && usmUserEntry.engineID != null) {
            n = this.engineID.compareTo(usmUserEntry.engineID);
        } else if (this.engineID != null && usmUserEntry.engineID == null) {
            n = 1;
        } else if (this.engineID == null && usmUserEntry.engineID != null) {
            n = -1;
        }
        if (n == 0 && (n = this.userName.compareTo(usmUserEntry.userName)) == 0) {
            n = this.usmUser.compareTo(usmUserEntry.usmUser);
        }
        return n;
    }

    public String toString() {
        return "UsmUserEntry[userName=" + this.userName + ",usmUser=" + this.usmUser + "]";
    }
}

