/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.util.GroupCache;
import org.apache.flink.shaded.guava31.com.google.common.base.Ticker;
import org.apache.flink.shaded.guava31.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava31.com.google.common.cache.RemovalNotification;

@NotThreadSafe
public class DefaultGroupCache<G, K, V>
implements GroupCache<G, K, V> {
    private final Cache<CacheKey<G, K>, V> cache;
    private final Map<G, Set<CacheKey<G, K>>> cachedBlobKeysPerJob = new HashMap<G, Set<CacheKey<G, K>>>();

    private DefaultGroupCache(Duration expireTimeout, int cacheSizeLimit, Ticker ticker) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize((long)cacheSizeLimit).expireAfterAccess(expireTimeout).ticker(ticker).removalListener(this::onCacheRemoval).build();
    }

    @Override
    public void clear() {
        this.cachedBlobKeysPerJob.clear();
        this.cache.cleanUp();
    }

    @Override
    public V get(G group, K key) {
        return (V)this.cache.getIfPresent(new CacheKey<G, K>(group, key));
    }

    @Override
    public void put(G group, K key, V value) {
        CacheKey<G, K> cacheKey = new CacheKey<G, K>(group, key);
        this.cache.put(cacheKey, value);
        this.cachedBlobKeysPerJob.computeIfAbsent(group, ignore -> new HashSet()).add(cacheKey);
    }

    @Override
    public void clearCacheForGroup(G group) {
        Set<CacheKey<G, K>> removed = this.cachedBlobKeysPerJob.remove(group);
        if (removed != null) {
            this.cache.invalidateAll(removed);
        }
    }

    private void onCacheRemoval(RemovalNotification<CacheKey<G, K>, V> removalNotification) {
        CacheKey cacheKey = (CacheKey)removalNotification.getKey();
        Object value = removalNotification.getValue();
        if (cacheKey != null && value != null) {
            this.cachedBlobKeysPerJob.computeIfPresent(cacheKey.getGroup(), (group, keys) -> {
                keys.remove(cacheKey);
                if (keys.isEmpty()) {
                    return null;
                }
                return keys;
            });
        }
    }

    public static class Factory<G, K, V> {
        private static final Duration DEFAULT_CACHE_EXPIRE_TIMEOUT = Duration.ofSeconds(300L);
        private static final int DEFAULT_CACHE_SIZE_LIMIT = 100;
        private static final Ticker DEFAULT_TICKER = Ticker.systemTicker();
        private final Duration cacheExpireTimeout;
        private final int cacheSizeLimit;
        private final Ticker ticker;

        public Factory() {
            this(DEFAULT_CACHE_EXPIRE_TIMEOUT, 100, DEFAULT_TICKER);
        }

        @VisibleForTesting
        public Factory(Duration cacheExpireTimeout, int cacheSizeLimit, Ticker ticker) {
            this.cacheExpireTimeout = cacheExpireTimeout;
            this.cacheSizeLimit = cacheSizeLimit;
            this.ticker = ticker;
        }

        public DefaultGroupCache<G, K, V> create() {
            return new DefaultGroupCache(this.cacheExpireTimeout, this.cacheSizeLimit, this.ticker);
        }
    }

    private static class CacheKey<G, K> {
        private final G group;
        private final K key;

        public CacheKey(G group, K key) {
            this.group = group;
            this.key = key;
        }

        public G getGroup() {
            return this.group;
        }

        public K getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.group, cacheKey.group) && Objects.equals(this.key, cacheKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.key);
        }
    }
}

