/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400ByteArray
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int length;
    private static final int defaultValue = 0;

    public AS400ByteArray(int length) {
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("length (" + String.valueOf(length) + ")", 1);
        }
        this.length = length;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    @Override
    public Object getDefaultValue() {
        return new byte[0];
    }

    @Override
    public int getInstanceType() {
        return 4;
    }

    @Override
    public Class getJavaType() {
        return byte[].class;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[this.length];
        this.toBytes(javaValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        int size = this.length;
        byte[] byteValue = (byte[])javaValue;
        int dataSize = size < byteValue.length ? size : byteValue.length;
        System.arraycopy(byteValue, 0, as400Value, offset, dataSize);
        for (int i = byteValue.length; i < size; ++i) {
            as400Value[offset + i] = 0;
        }
        return size;
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return this.toObject(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        int size = this.length;
        byte[] javaValue = new byte[size];
        System.arraycopy(as400Value, offset, javaValue, 0, size);
        return javaValue;
    }
}

