/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLNClob
extends SQLDataBase {
    private int length_ = 0;
    private int maxLength_;
    private String value_;
    private Object savedObject_;

    SQLNClob(int maxLength, SQLConversionSettings settings) {
        super(settings);
        this.maxLength_ = maxLength;
        this.value_ = "";
    }

    @Override
    public Object clone() {
        return new SQLNClob(this.maxLength_, this.settings_);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToInt(rawBytes, offset);
        int bidiStringType = this.settings_.getBidiStringType();
        if (bidiStringType == -1) {
            bidiStringType = ccsidConverter.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        this.value_ = ccsidConverter.byteArrayToString(rawBytes, offset + 4, this.length_, bidiConversionProperties);
        this.savedObject_ = null;
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        try {
            int bidiStringType = this.settings_.getBidiStringType();
            if (bidiStringType == -1) {
                bidiStringType = ccsidConverter.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            byte[] temp = ccsidConverter.stringToByteArray(this.value_, bidiConversionProperties);
            BinaryConverter.intToByteArray(temp.length, rawBytes, offset);
            if (temp.length > this.maxLength_) {
                this.maxLength_ = temp.length;
                JDError.throwSQLException((Object)this, "HY000", "Change Descriptor");
            }
            System.arraycopy(temp, 0, rawBytes, offset + 4, temp.length);
        }
        catch (Exception e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof String) {
            String s = (String)object;
            this.truncated_ = s.length() > this.maxLength_ ? s.length() - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Clob || object instanceof InputStream || object instanceof Reader || object instanceof SQLXML)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.length_ = scale != -1 ? scale : -2;
    }

    private void doConversion() throws SQLException {
        try {
            Object object = this.savedObject_;
            if (this.savedObject_ instanceof String) {
                this.value_ = (String)object;
            } else if (object instanceof Reader) {
                this.value_ = SQLNClob.getStringFromReader((Reader)object, this.length_, this);
            } else if (object instanceof Clob) {
                Clob clob = (Clob)object;
                this.value_ = clob.getSubString(1L, (int)clob.length());
            } else if (object instanceof SQLXML) {
                SQLXML xml = (SQLXML)object;
                this.value_ = xml.getString();
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
            int valueLength = this.value_.length();
            if (valueLength > this.maxLength_) {
                this.value_ = this.value_.substring(0, this.maxLength_);
                this.truncated_ = valueLength - this.maxLength_;
                this.outOfBounds_ = false;
            } else {
                this.truncated_ = 0;
                this.outOfBounds_ = false;
            }
            this.length_ = this.value_.length();
        }
        finally {
            this.savedObject_ = null;
        }
    }

    @Override
    public int getSQLType() {
        return 33;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_;
    }

    @Override
    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCNClob";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "NCLOB";
    }

    @Override
    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 408;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 2011;
    }

    @Override
    public String getTypeName() {
        return "NCLOB";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.value_.length();
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.value_));
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.value_);
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCNClob(this.value_, this.maxLength_);
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public String getNString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXML(this.value_);
    }

    @Override
    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

