/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.marshaller;

import org.apache.ignite.IgniteCheckedException;

public class MappingExchangeResult {
    private final String acceptedClsName;
    private final IgniteCheckedException error;
    private final ResultType resType;

    private MappingExchangeResult(ResultType resType, String acceptedClsName, IgniteCheckedException error) {
        this.resType = resType;
        this.acceptedClsName = acceptedClsName;
        this.error = error;
    }

    public String className() {
        return this.acceptedClsName;
    }

    public IgniteCheckedException error() {
        return this.error;
    }

    public boolean successful() {
        return this.resType == ResultType.SUCCESS;
    }

    public boolean exchangeDisabled() {
        return this.resType == ResultType.EXCHANGE_DISABLED;
    }

    static MappingExchangeResult createSuccessfulResult(String acceptedClsName) {
        assert (acceptedClsName != null);
        return new MappingExchangeResult(ResultType.SUCCESS, acceptedClsName, null);
    }

    static MappingExchangeResult createFailureResult(IgniteCheckedException error) {
        assert (error != null);
        return new MappingExchangeResult(ResultType.FAILURE, null, error);
    }

    static MappingExchangeResult createExchangeDisabledResult() {
        return new MappingExchangeResult(ResultType.EXCHANGE_DISABLED, null, null);
    }

    private static enum ResultType {
        SUCCESS,
        FAILURE,
        EXCHANGE_DISABLED;

    }
}

