/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.sql;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteSqlQueryJoinBenchmark2
extends IgniteAbstractBenchmark {
    private static final long TBL_SIZE = 100000L;
    private static final String SUBQUERY_PARAM = "subquery";
    private static final String SKIP_INIT_PARAM = "skipInit";
    private static final String LAST_PARAM_KEY = "LAST_PARAM_KEY";
    private Subquery subqry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        String subqueryName = this.args.getStringParameter(SUBQUERY_PARAM, null);
        if (!F.isEmpty((String)subqueryName)) {
            this.subqry = Subquery.valueOfSafe(subqueryName.trim().toUpperCase());
        }
        if (this.subqry == null) {
            throw new IllegalArgumentException("The \"subquery\" is mandatory and should be one of the " + Arrays.toString((Object[])Subquery.values()));
        }
        if (this.args.getBooleanParameter(SKIP_INIT_PARAM, false)) {
            return;
        }
        IgniteSemaphore sem = this.ignite().semaphore("setup", 1, true, true);
        try {
            if (sem.tryAcquire()) {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Create tables...");
                this.init();
            } else {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Waits for setup...");
                sem.acquire();
            }
        }
        finally {
            sem.release();
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Done");
    }

    private void init() {
        this.sql("create table color(id long primary key, color varchar) with \"template=replicated\"", new Object[0]);
        long id = 0L;
        for (String color : Arrays.asList("red", "orange", "yellow", "green", "blue", "indigo", "violet")) {
            this.sql("insert into color(id, color) values(?, ?)", ++id, color);
        }
        this.sql("create table organization(id long primary key, name varchar)", new Object[0]);
        this.sql("create table person(id long, org_id long, name varchar, primary key (id, org_id)) with \"affinity_key=org_id\"", new Object[0]);
        for (long i = 0L; i < 100000L; ++i) {
            this.sql("insert into organization(id, name) values (?, ?)", i, "org" + i);
            this.sql("insert into person(id, org_id, name) values (?, ?, ?)", i, i, "person" + i);
            if (i % 1000L != 0L || i == 0L) continue;
            BenchmarkUtils.println((String)(i + " entries inserted"));
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long lowerBound = (Long)ctx.getOrDefault(LAST_PARAM_KEY, 0L);
        long upperBound = lowerBound + 10L;
        List<List<?>> rows = this.sql(this.subqry.sql(), lowerBound, upperBound);
        if (rows.isEmpty()) {
            throw new Exception("Empty result for query=\"" + this.subqry.sql() + "\", param=[" + lowerBound + ", " + upperBound + "]");
        }
        long newLowerBound = lowerBound + 5L;
        if (newLowerBound + 10L > 100000L) {
            newLowerBound = 0L;
        }
        ctx.put(LAST_PARAM_KEY, newLowerBound);
        return true;
    }

    private List<List<?>> sql(String sql, Object ... args) {
        return ((IgniteEx)this.ignite()).context().query().querySqlFields(new SqlFieldsQuery(sql).setSchema("PUBLIC").setArgs(args), false).getAll();
    }

    private static enum Subquery {
        SELECT_EXPR_UNCORRELATED("select p.name, p.id, (select name from organization where id = DAY_OF_WEEK(NOW())) as org_name from person p where p.id >= ? and p.id < ?"),
        SELECT_EXPR_CORRELATED("select p.name, p.id, (select name from organization where id = org_id) as org_name from person p where p.id >= ? and p.id < ?"),
        TABLE_LIST("select p.id, p.name, o.name from person p, (select id, name from organization where id >= ? and id < ?) o where p.org_id = o.id"),
        IN_EXPR_UNCORRELATED("select p.id, p.name from person p where p.org_id in (select id from organization where id >= ? and id < ?)"),
        IN_EXPR_CORRELATED("select p.id, p.name from person p where p.org_id in (select id from organization where id = p.id) and p.id >= ? and p.id < ?"),
        EXISTS_EXPR("select p.id, p.name from person p where EXISTS (select 1 from organization where id = p.org_id and id >= ? and id < ?)"),
        OUTER_IS_BIG_AND_INNER_IS_SMALL("select p.id, p.name, c.color, ? as p1, ? as p2 from person p, (select id, color from color) c where c.id = (MOD(p.id, 7) + 1) limit 10"),
        SINGLE_PARTITION_OPTIMIZATION("select p.id, p.name from person p where EXISTS (select 1 from organization where id = ? and id = p.org_id) and ? > -1");

        private static final Map<String, Subquery> values;
        private final String sql;

        private Subquery(String sql) {
            this.sql = sql;
        }

        String sql() {
            return this.sql;
        }

        static Subquery valueOfSafe(String name) {
            return values.get(name);
        }

        static {
            values = new HashMap<String, Subquery>();
            for (Subquery s : Subquery.values()) {
                values.put(s.name(), s);
            }
        }
    }
}

