/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.diagnostic;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.diagnostic.DiagnosticPagelocksCommandArg;
import org.apache.ignite.internal.management.diagnostic.PageLocksResult;
import org.apache.ignite.internal.management.diagnostic.PageLocksTask;
import org.apache.ignite.internal.util.typedef.F;

public class DiagnosticPagelocksCommand
implements ComputeCommand<DiagnosticPagelocksCommandArg, Map<ClusterNode, PageLocksResult>> {
    @Override
    public String description() {
        return "View pages locks state information on the node or nodes";
    }

    @Override
    public Class<DiagnosticPagelocksCommandArg> argClass() {
        return DiagnosticPagelocksCommandArg.class;
    }

    @Override
    public Class<PageLocksTask> taskClass() {
        return PageLocksTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, DiagnosticPagelocksCommandArg arg) {
        if (arg.all()) {
            return nodes;
        }
        if (F.isEmpty(arg.nodes())) {
            return null;
        }
        HashSet<String> argNodes = new HashSet<String>(Arrays.asList(arg.nodes()));
        return nodes.stream().filter(entry -> argNodes.contains(entry.nodeId().toString()) || argNodes.contains(String.valueOf(entry.consistentId()))).collect(Collectors.toList());
    }

    @Override
    public void printResult(DiagnosticPagelocksCommandArg arg, Map<ClusterNode, PageLocksResult> res, Consumer<String> printer) {
        res.forEach((n, res0) -> printer.accept(n.id() + " (" + n.consistentId() + ") " + res0.result()));
    }
}

