/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class AssignmentsSerializer
extends VersionedSerializer<Assignments> {
    public static final AssignmentsSerializer INSTANCE = new AssignmentsSerializer();

    protected void writeExternalData(Assignments assignments, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)assignments.nodes().size());
        for (Assignment assignment : assignments.nodes()) {
            AssignmentsSerializer.writeAssignment(assignment, out);
        }
        out.writeBoolean(assignments.force());
        HybridTimestamp.hybridTimestamp((long)assignments.timestamp()).writeTo(out);
        out.writeBoolean(assignments.fromReset());
    }

    private static void writeAssignment(Assignment assignment, IgniteDataOutput out) throws IOException {
        out.writeUTF(assignment.consistentId());
        out.writeBoolean(assignment.isPeer());
    }

    protected Assignments readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        Set<Assignment> nodes = AssignmentsSerializer.readNodes(in);
        boolean force = in.readBoolean();
        HybridTimestamp timestamp = HybridTimestamp.readFrom((IgniteDataInput)in);
        boolean fromReset = in.readBoolean();
        return force ? Assignments.forced(nodes, timestamp.longValue()) : Assignments.of(nodes, timestamp.longValue(), fromReset);
    }

    private static Set<Assignment> readNodes(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        HashSet<Assignment> nodes = new HashSet<Assignment>();
        for (int i = 0; i < length; ++i) {
            nodes.add(AssignmentsSerializer.readAssignment(in));
        }
        return nodes;
    }

    private static Assignment readAssignment(IgniteDataInput in) throws IOException {
        String consistentId = in.readUTF();
        boolean isPeer = in.readBoolean();
        return isPeer ? Assignment.forPeer(consistentId) : Assignment.forLearner(consistentId);
    }
}

