/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.DataContexts;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.fun.SqlAvgAggFunction;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.Accumulators;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class PlanUtils {
    public static DataContext defaultDataContext() {
        return DataContexts.of(Map.of(DataContext.Variable.TIME_ZONE.camelName, TimeZone.getDefault()));
    }

    public static boolean complexDistinctAgg(List<AggregateCall> aggCalls) {
        for (AggregateCall call : aggCalls) {
            if (!call.isDistinct() || !(call.getAggregation() instanceof SqlCountAggFunction) && !(call.getAggregation() instanceof SqlAvgAggFunction) && !(call.getAggregation() instanceof SqlSumAggFunction) && !(call.getAggregation() instanceof SqlMinMaxAggFunction)) continue;
            return true;
        }
        return false;
    }

    public static RelDataType createSortAggRowType(ImmutableBitSet grpKeys, IgniteTypeFactory typeFactory, RelDataType inputType, List<AggregateCall> aggregateCalls) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        Iterator iterator = grpKeys.iterator();
        while (iterator.hasNext()) {
            int fieldIdx = (Integer)iterator.next();
            RelDataTypeField fld = (RelDataTypeField)inputType.getFieldList().get(fieldIdx);
            builder.add(fld);
        }
        PlanUtils.addAccumulatorFields(typeFactory, aggregateCalls, inputType, (RelDataTypeFactory.Builder)builder);
        return builder.build();
    }

    public static RelDataType createHashAggRowType(List<ImmutableBitSet> groupSets, IgniteTypeFactory typeFactory, RelDataType inputType, List<AggregateCall> aggregateCalls) {
        ImmutableBitSet fieldIndices = ImmutableBitSet.union(groupSets);
        Mapping mapping = Commons.trimmingMapping(fieldIndices.length(), fieldIndices);
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            int source = mapping.getSource(i);
            RelDataTypeField fld = (RelDataTypeField)inputType.getFieldList().get(source);
            builder.add(fld);
        }
        PlanUtils.addAccumulatorFields(typeFactory, aggregateCalls, inputType, (RelDataTypeFactory.Builder)builder);
        builder.add("_GROUP_ID", SqlTypeName.TINYINT);
        return builder.build();
    }

    private static void addAccumulatorFields(IgniteTypeFactory typeFactory, List<AggregateCall> aggregateCalls, RelDataType inputType, RelDataTypeFactory.Builder builder) {
        Accumulators accumulators = new Accumulators(typeFactory);
        for (int i = 0; i < aggregateCalls.size(); ++i) {
            AggregateCall call = aggregateCalls.get(i);
            Accumulator acc = accumulators.accumulatorFactory(PlanUtils.defaultDataContext(), call, inputType).get();
            RelDataType fieldType = call.getType().getSqlTypeName().allowsScale() ? call.type : acc.returnType(typeFactory);
            String fieldName = "_ACC" + i;
            builder.add(fieldName, fieldType);
        }
    }
}

