/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.Map;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.FutureGrantManager;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.catalog.CatalogDispatcher;
import org.apache.gravitino.connector.BaseCatalog;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class CatalogHookDispatcher
implements CatalogDispatcher {
    private final CatalogDispatcher dispatcher;

    public CatalogHookDispatcher(CatalogDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public NameIdentifier[] listCatalogs(Namespace namespace) throws NoSuchMetalakeException {
        return this.dispatcher.listCatalogs(namespace);
    }

    @Override
    public Catalog[] listCatalogsInfo(Namespace namespace) throws NoSuchMetalakeException {
        return this.dispatcher.listCatalogsInfo(namespace);
    }

    @Override
    public Catalog loadCatalog(NameIdentifier ident) throws NoSuchCatalogException {
        return this.dispatcher.loadCatalog(ident);
    }

    @Override
    public Catalog createCatalog(NameIdentifier ident, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws NoSuchMetalakeException, CatalogAlreadyExistsException {
        FutureGrantManager futureGrantManager;
        Catalog catalog = this.dispatcher.createCatalog(ident, type, provider, comment, properties);
        OwnerManager ownerManager = GravitinoEnv.getInstance().ownerManager();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.namespace().level(0), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.CATALOG), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        if ((futureGrantManager = GravitinoEnv.getInstance().futureGrantManager()) != null && catalog instanceof BaseCatalog) {
            futureGrantManager.grantNewlyCreatedCatalog(ident.namespace().level(0), (BaseCatalog)catalog);
        }
        return catalog;
    }

    @Override
    public Catalog alterCatalog(NameIdentifier ident, CatalogChange ... changes) throws NoSuchCatalogException, IllegalArgumentException {
        return this.dispatcher.alterCatalog(ident, changes);
    }

    @Override
    public boolean dropCatalog(NameIdentifier ident) {
        return this.dispatcher.dropCatalog(ident);
    }

    @Override
    public void testConnection(NameIdentifier ident, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        this.dispatcher.testConnection(ident, type, provider, comment, properties);
    }

    @Override
    public boolean catalogExists(NameIdentifier ident) {
        return this.dispatcher.catalogExists(ident);
    }
}

