/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.metalake;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.exceptions.AlreadyExistsException;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.BaseMetalake;
import org.apache.gravitino.meta.SchemaVersion;
import org.apache.gravitino.metalake.MetalakeDispatcher;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetalakeManager
implements MetalakeDispatcher {
    private static final String METALAKE_DOES_NOT_EXIST_MSG = "Metalake %s does not exist";
    private static final Logger LOG = LoggerFactory.getLogger(MetalakeManager.class);
    private final EntityStore store;
    private final IdGenerator idGenerator;

    public MetalakeManager(EntityStore store, IdGenerator idGenerator) {
        this.store = store;
        this.idGenerator = idGenerator;
    }

    public BaseMetalake[] listMetalakes() {
        try {
            return (BaseMetalake[])this.store.list(Namespace.empty(), BaseMetalake.class, Entity.EntityType.METALAKE).stream().toArray(BaseMetalake[]::new);
        }
        catch (IOException ioe) {
            LOG.error("Listing Metalakes failed due to storage issues.", (Throwable)ioe);
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public BaseMetalake loadMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        try {
            return this.store.get(ident, Entity.EntityType.METALAKE, BaseMetalake.class);
        }
        catch (NoSuchEntityException e) {
            LOG.warn("Metalake {} does not exist", (Object)ident, (Object)e);
            throw new NoSuchMetalakeException(METALAKE_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (IOException ioe) {
            LOG.error("Loading Metalake {} failed due to storage issues", (Object)ident, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public BaseMetalake createMetalake(NameIdentifier ident, String comment, Map<String, String> properties) throws MetalakeAlreadyExistsException {
        long uid = this.idGenerator.nextId();
        StringIdentifier stringId = StringIdentifier.fromId(uid);
        BaseMetalake metalake = BaseMetalake.builder().withId(uid).withName(ident.name()).withComment(comment).withProperties(StringIdentifier.newPropertiesWithId(stringId, properties)).withVersion(SchemaVersion.V_0_1).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put(metalake, false);
            return metalake;
        }
        catch (EntityAlreadyExistsException | AlreadyExistsException e) {
            LOG.warn("Metalake {} already exists", (Object)ident, e);
            throw new MetalakeAlreadyExistsException("Metalake %s already exists", new Object[]{ident});
        }
        catch (IOException ioe) {
            LOG.error("Loading Metalake {} failed due to storage issues", (Object)ident, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public BaseMetalake alterMetalake(NameIdentifier ident, MetalakeChange ... changes) throws NoSuchMetalakeException, IllegalArgumentException {
        try {
            return this.store.update(ident, BaseMetalake.class, Entity.EntityType.METALAKE, metalake -> {
                BaseMetalake.Builder builder = BaseMetalake.builder().withId(metalake.id()).withName(metalake.name()).withComment(metalake.comment()).withProperties(metalake.properties()).withVersion(metalake.getVersion());
                AuditInfo newInfo = AuditInfo.builder().withCreator(metalake.auditInfo().creator()).withCreateTime(metalake.auditInfo().createTime()).withLastModifier(metalake.auditInfo().creator()).withLastModifiedTime(Instant.now()).build();
                builder.withAuditInfo(newInfo);
                HashMap newProps = metalake.properties() == null ? Maps.newHashMap() : Maps.newHashMap(metalake.properties());
                builder = this.updateEntity(builder, newProps, changes);
                return builder.build();
            });
        }
        catch (NoSuchEntityException ne) {
            LOG.warn("Metalake {} does not exist", (Object)ident, (Object)ne);
            throw new NoSuchMetalakeException(METALAKE_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Altering Metalake {} failed due to invalid changes", (Object)ident, (Object)iae);
            throw iae;
        }
        catch (IOException ioe) {
            LOG.error("Loading Metalake {} failed due to storage issues", (Object)ident, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean dropMetalake(NameIdentifier ident) {
        try {
            return this.store.delete(ident, Entity.EntityType.METALAKE);
        }
        catch (IOException ioe) {
            LOG.error("Deleting metalake {} failed due to storage issues", (Object)ident, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    private BaseMetalake.Builder updateEntity(BaseMetalake.Builder builder, Map<String, String> newProps, MetalakeChange ... changes) {
        for (MetalakeChange change : changes) {
            if (change instanceof MetalakeChange.RenameMetalake) {
                MetalakeChange.RenameMetalake rename = (MetalakeChange.RenameMetalake)change;
                builder.withName(rename.getNewName());
                continue;
            }
            if (change instanceof MetalakeChange.UpdateMetalakeComment) {
                MetalakeChange.UpdateMetalakeComment comment = (MetalakeChange.UpdateMetalakeComment)change;
                builder.withComment(comment.getNewComment());
                continue;
            }
            if (change instanceof MetalakeChange.SetProperty) {
                MetalakeChange.SetProperty setProperty = (MetalakeChange.SetProperty)change;
                newProps.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (change instanceof MetalakeChange.RemoveProperty) {
                MetalakeChange.RemoveProperty removeProperty = (MetalakeChange.RemoveProperty)change;
                newProps.remove(removeProperty.getProperty());
                continue;
            }
            throw new IllegalArgumentException("Unknown metalake change type: " + change);
        }
        return builder.withProperties(newProps);
    }
}

