/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.kv;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.gravitino.storage.FunctionUtils;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.storage.NameMappingService;
import org.apache.gravitino.storage.RandomIdGenerator;
import org.apache.gravitino.storage.kv.TransactionalKvBackend;
import org.apache.gravitino.utils.ByteUtils;
import org.apache.gravitino.utils.Bytes;

@ThreadSafe
public class KvNameMappingService
implements NameMappingService {
    @VisibleForTesting
    final ReentrantReadWriteLock lock;
    @VisibleForTesting
    final IdGenerator idGenerator = new RandomIdGenerator();
    static final byte[] GENERAL_NAME_MAPPING_PREFIX = new byte[]{29, 0, 0};
    private static final byte[] NAME_PREFIX = Bytes.concat(GENERAL_NAME_MAPPING_PREFIX, "name_".getBytes(StandardCharsets.UTF_8));
    private static final byte[] ID_PREFIX = Bytes.concat(GENERAL_NAME_MAPPING_PREFIX, "id_".getBytes(StandardCharsets.UTF_8));
    @VisibleForTesting
    final TransactionalKvBackend transactionalKvBackend;

    public KvNameMappingService(TransactionalKvBackend transactionalKvBackend, ReentrantReadWriteLock reentrantReadWriteLock) {
        this.transactionalKvBackend = transactionalKvBackend;
        this.lock = reentrantReadWriteLock;
    }

    @Override
    public Long getIdByName(String name) throws IOException {
        byte[] nameByte = KvNameMappingService.getNameKey(name);
        return FunctionUtils.executeInTransaction(() -> {
            byte[] idByte = this.transactionalKvBackend.get(nameByte);
            return idByte == null ? null : Long.valueOf(ByteUtils.byteToLong(idByte));
        }, this.transactionalKvBackend);
    }

    @Override
    public String getNameById(long id) throws IOException {
        byte[] idByte = KvNameMappingService.getIdKey(id);
        return FunctionUtils.executeInTransaction(() -> {
            byte[] name = this.transactionalKvBackend.get(idByte);
            return name == null ? null : new String(name, StandardCharsets.UTF_8);
        }, this.transactionalKvBackend);
    }

    private long bindNameAndId(String name) throws IOException {
        byte[] nameByte = KvNameMappingService.getNameKey(name);
        long id = this.idGenerator.nextId();
        byte[] idByte = KvNameMappingService.getIdKey(id);
        return FunctionUtils.executeInTransaction(() -> {
            this.transactionalKvBackend.put(nameByte, ByteUtils.longToByte(id), false);
            this.transactionalKvBackend.put(idByte, name.getBytes(StandardCharsets.UTF_8), false);
            return id;
        }, this.transactionalKvBackend);
    }

    @Override
    public boolean updateName(String oldName, String newName) throws IOException {
        return FunctionUtils.executeInTransaction(() -> {
            byte[] nameByte = KvNameMappingService.getNameKey(oldName);
            byte[] oldIdValue = this.transactionalKvBackend.get(nameByte);
            if (oldIdValue == null) {
                return false;
            }
            this.transactionalKvBackend.delete(nameByte);
            this.transactionalKvBackend.put(KvNameMappingService.getNameKey(newName), oldIdValue, true);
            this.transactionalKvBackend.put(oldIdValue, newName.getBytes(StandardCharsets.UTF_8), true);
            return true;
        }, this.transactionalKvBackend);
    }

    @Override
    public boolean unbindNameAndId(String name) throws IOException {
        byte[] nameByte = Bytes.concat(NAME_PREFIX, name.getBytes(StandardCharsets.UTF_8));
        return FunctionUtils.executeInTransaction(() -> {
            byte[] idByte = this.transactionalKvBackend.get(nameByte);
            if (idByte == null) {
                return false;
            }
            this.transactionalKvBackend.delete(nameByte);
            this.transactionalKvBackend.delete(Bytes.concat(ID_PREFIX, idByte));
            return true;
        }, this.transactionalKvBackend);
    }

    @Override
    public void close() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOrCreateIdFromName(String name) throws IOException {
        Long id = this.getIdByName(name);
        if (id == null) {
            KvNameMappingService kvNameMappingService = this;
            synchronized (kvNameMappingService) {
                id = this.getIdByName(name);
                if (id == null) {
                    id = this.bindNameAndId(name);
                }
            }
        }
        return id;
    }

    private static byte[] getIdKey(long id) {
        return Bytes.concat(ID_PREFIX, ByteUtils.longToByte(id));
    }

    private static byte[] getNameKey(String name) {
        return Bytes.concat(NAME_PREFIX, name.getBytes(StandardCharsets.UTF_8));
    }
}

