/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.CatalogPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface CatalogMetaMapper {
    public static final String TABLE_NAME = "catalog_meta";

    @Select(value={"SELECT catalog_id as catalogId, catalog_name as catalogName, metalake_id as metalakeId, type, provider, catalog_comment as catalogComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM catalog_meta WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public List<CatalogPO> listCatalogPOsByMetalakeId(@Param(value="metalakeId") Long var1);

    @Select(value={"SELECT catalog_id as catalogId FROM catalog_meta WHERE metalake_id = #{metalakeId} AND catalog_name = #{catalogName} AND deleted_at = 0"})
    public Long selectCatalogIdByMetalakeIdAndName(@Param(value="metalakeId") Long var1, @Param(value="catalogName") String var2);

    @Select(value={"SELECT catalog_id as catalogId, catalog_name as catalogName, metalake_id as metalakeId, type, provider, catalog_comment as catalogComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM catalog_meta WHERE metalake_id = #{metalakeId} AND catalog_name = #{catalogName} AND deleted_at = 0"})
    public CatalogPO selectCatalogMetaByMetalakeIdAndName(@Param(value="metalakeId") Long var1, @Param(value="catalogName") String var2);

    @Select(value={"SELECT catalog_id as catalogId, catalog_name as catalogName, metalake_id as metalakeId, type, provider, catalog_comment as catalogComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM catalog_meta WHERE catalog_id = #{catalogId} AND deleted_at = 0"})
    public CatalogPO selectCatalogMetaById(@Param(value="catalogId") Long var1);

    @Insert(value={"INSERT INTO catalog_meta(catalog_id, catalog_name, metalake_id, type, provider, catalog_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{catalogMeta.catalogId}, #{catalogMeta.catalogName}, #{catalogMeta.metalakeId}, #{catalogMeta.type}, #{catalogMeta.provider}, #{catalogMeta.catalogComment}, #{catalogMeta.properties}, #{catalogMeta.auditInfo}, #{catalogMeta.currentVersion}, #{catalogMeta.lastVersion}, #{catalogMeta.deletedAt} )"})
    public void insertCatalogMeta(@Param(value="catalogMeta") CatalogPO var1);

    @Insert(value={"INSERT INTO catalog_meta(catalog_id, catalog_name, metalake_id, type, provider, catalog_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{catalogMeta.catalogId}, #{catalogMeta.catalogName}, #{catalogMeta.metalakeId}, #{catalogMeta.type}, #{catalogMeta.provider}, #{catalogMeta.catalogComment}, #{catalogMeta.properties}, #{catalogMeta.auditInfo}, #{catalogMeta.currentVersion}, #{catalogMeta.lastVersion}, #{catalogMeta.deletedAt} ) ON DUPLICATE KEY UPDATE catalog_name = #{catalogMeta.catalogName}, metalake_id = #{catalogMeta.metalakeId}, type = #{catalogMeta.type}, provider = #{catalogMeta.provider}, catalog_comment = #{catalogMeta.catalogComment}, properties = #{catalogMeta.properties}, audit_info = #{catalogMeta.auditInfo}, current_version = #{catalogMeta.currentVersion}, last_version = #{catalogMeta.lastVersion}, deleted_at = #{catalogMeta.deletedAt}"})
    public void insertCatalogMetaOnDuplicateKeyUpdate(@Param(value="catalogMeta") CatalogPO var1);

    @Update(value={"UPDATE catalog_meta SET catalog_name = #{newCatalogMeta.catalogName}, metalake_id = #{newCatalogMeta.metalakeId}, type = #{newCatalogMeta.type}, provider = #{newCatalogMeta.provider}, catalog_comment = #{newCatalogMeta.catalogComment}, properties = #{newCatalogMeta.properties}, audit_info = #{newCatalogMeta.auditInfo}, current_version = #{newCatalogMeta.currentVersion}, last_version = #{newCatalogMeta.lastVersion}, deleted_at = #{newCatalogMeta.deletedAt} WHERE catalog_id = #{oldCatalogMeta.catalogId} AND catalog_name = #{oldCatalogMeta.catalogName} AND metalake_id = #{oldCatalogMeta.metalakeId} AND type = #{oldCatalogMeta.type} AND provider = #{oldCatalogMeta.provider} AND catalog_comment = #{oldCatalogMeta.catalogComment} AND properties = #{oldCatalogMeta.properties} AND audit_info = #{oldCatalogMeta.auditInfo} AND current_version = #{oldCatalogMeta.currentVersion} AND last_version = #{oldCatalogMeta.lastVersion} AND deleted_at = 0"})
    public Integer updateCatalogMeta(@Param(value="newCatalogMeta") CatalogPO var1, @Param(value="oldCatalogMeta") CatalogPO var2);

    @Update(value={"UPDATE catalog_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0"})
    public Integer softDeleteCatalogMetasByCatalogId(@Param(value="catalogId") Long var1);

    @Update(value={"UPDATE catalog_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public Integer softDeleteCatalogMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Delete(value={"DELETE FROM catalog_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteCatalogMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

