/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.SecurableObjectPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface SecurableObjectMapper {
    public static final String SECURABLE_OBJECT_TABLE_NAME = "role_meta_securable_object";
    public static final String ROLE_TABLE_NAME = "role_meta";

    @Insert(value={"<script>", "INSERT INTO role_meta_securable_object(role_id, metadata_object_id, type, privilege_names, privilege_conditions,  current_version, last_version, deleted_at) VALUES ", "<foreach collection='securableObjects' item='item' separator=','>", "(#{item.roleId}, #{item.metadataObjectId}, #{item.type}, #{item.privilegeNames}, #{item.privilegeConditions}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})", "</foreach>", "</script>"})
    public void batchInsertSecurableObjects(@Param(value="securableObjects") List<SecurableObjectPO> var1);

    @Update(value={"UPDATE role_meta_securable_object SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE role_id = #{roleId} AND deleted_at = 0"})
    public void softDeleteSecurableObjectsByRoleId(@Param(value="roleId") Long var1);

    @Update(value={"UPDATE role_meta_securable_object ob SET ob.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE exists (SELECT * from role_meta ro WHERE ro.metalake_id = #{metalakeId} AND ro.role_id = ob.role_id AND ro.deleted_at = 0) AND ob.deleted_at = 0"})
    public void softDeleteRoleMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Select(value={"SELECT role_id as roleId, metadata_object_id as metadataObjectId, type as type, privilege_names as privilegeNames, privilege_conditions as privilegeConditions, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM role_meta_securable_object WHERE role_id = #{roleId} AND deleted_at = 0"})
    public List<SecurableObjectPO> listSecurableObjectsByRoleId(@Param(value="roleId") Long var1);

    @Delete(value={"DELETE FROM role_meta_securable_object WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteSecurableObjectsByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

