/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.storage.relational.po.CatalogPO;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.po.MetalakePO;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.service.FilesetMetaService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.RoleMetaService;
import org.apache.gravitino.storage.relational.service.SchemaMetaService;
import org.apache.gravitino.storage.relational.service.TableMetaService;
import org.apache.gravitino.storage.relational.service.TopicMetaService;

public class MetadataObjectService {
    private static final String DOT = ".";
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    private MetadataObjectService() {
    }

    public static long getMetadataObjectId(long metalakeId, String fullName, MetadataObject.Type type) {
        if (type == MetadataObject.Type.METALAKE) {
            return MetalakeMetaService.getInstance().getMetalakeIdByName(fullName);
        }
        List names = DOT_SPLITTER.splitToList((CharSequence)fullName);
        if (type == MetadataObject.Type.ROLE) {
            return RoleMetaService.getInstance().getRoleIdByMetalakeIdAndName(metalakeId, (String)names.get(0));
        }
        long catalogId = CatalogMetaService.getInstance().getCatalogIdByMetalakeIdAndName(metalakeId, (String)names.get(0));
        if (type == MetadataObject.Type.CATALOG) {
            return catalogId;
        }
        long schemaId = SchemaMetaService.getInstance().getSchemaIdByCatalogIdAndName(catalogId, (String)names.get(1));
        if (type == MetadataObject.Type.SCHEMA) {
            return schemaId;
        }
        if (type == MetadataObject.Type.FILESET) {
            return FilesetMetaService.getInstance().getFilesetIdBySchemaIdAndName(schemaId, (String)names.get(2));
        }
        if (type == MetadataObject.Type.TOPIC) {
            return TopicMetaService.getInstance().getTopicIdBySchemaIdAndName(schemaId, (String)names.get(2));
        }
        if (type == MetadataObject.Type.TABLE) {
            return TableMetaService.getInstance().getTableIdBySchemaIdAndName(schemaId, (String)names.get(2));
        }
        throw new IllegalArgumentException(String.format("Doesn't support the type %s", type));
    }

    @Nullable
    public static String getMetadataObjectFullName(String type, long metadataObjectId) {
        MetadataObject.Type metadatatype = MetadataObject.Type.valueOf((String)type);
        if (metadatatype == MetadataObject.Type.METALAKE) {
            MetalakePO metalakePO = MetalakeMetaService.getInstance().getMetalakePOById(metadataObjectId);
            if (metalakePO == null) {
                return null;
            }
            return metalakePO.getMetalakeName();
        }
        if (metadatatype == MetadataObject.Type.CATALOG) {
            return MetadataObjectService.getCatalogFullName(metadataObjectId);
        }
        if (metadatatype == MetadataObject.Type.SCHEMA) {
            return MetadataObjectService.getSchemaFullName(metadataObjectId);
        }
        if (metadatatype == MetadataObject.Type.TABLE) {
            TablePO tablePO = TableMetaService.getInstance().getTablePOById(metadataObjectId);
            if (tablePO == null) {
                return null;
            }
            String schemaName = MetadataObjectService.getSchemaFullName(tablePO.getSchemaId());
            if (schemaName == null) {
                return null;
            }
            return DOT_JOINER.join((Object)schemaName, (Object)tablePO.getTableName(), new Object[0]);
        }
        if (metadatatype == MetadataObject.Type.TOPIC) {
            TopicPO topicPO = TopicMetaService.getInstance().getTopicPOById(metadataObjectId);
            if (topicPO == null) {
                return null;
            }
            String schemaName = MetadataObjectService.getSchemaFullName(topicPO.getSchemaId());
            if (schemaName == null) {
                return null;
            }
            return DOT_JOINER.join((Object)schemaName, (Object)topicPO.getTopicName(), new Object[0]);
        }
        if (metadatatype == MetadataObject.Type.FILESET) {
            FilesetPO filesetPO = FilesetMetaService.getInstance().getFilesetPOById(metadataObjectId);
            if (filesetPO == null) {
                return null;
            }
            String schemaName = MetadataObjectService.getSchemaFullName(filesetPO.getSchemaId());
            if (schemaName == null) {
                return null;
            }
            return DOT_JOINER.join((Object)schemaName, (Object)filesetPO.getFilesetName(), new Object[0]);
        }
        throw new IllegalArgumentException(String.format("Doesn't support the type %s", metadatatype));
    }

    @Nullable
    private static String getCatalogFullName(Long entityId) {
        CatalogPO catalogPO = CatalogMetaService.getInstance().getCatalogPOById(entityId);
        if (catalogPO == null) {
            return null;
        }
        return catalogPO.getCatalogName();
    }

    @Nullable
    private static String getSchemaFullName(Long entityId) {
        SchemaPO schemaPO = SchemaMetaService.getInstance().getSchemaPOById(entityId);
        if (schemaPO == null) {
            return null;
        }
        String catalogName = MetadataObjectService.getCatalogFullName(schemaPO.getCatalogId());
        if (catalogName == null) {
            return null;
        }
        return DOT_JOINER.join((Object)catalogName, (Object)schemaPO.getSchemaName(), new Object[0]);
    }
}

