/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.meta.BaseMetalake;
import org.apache.gravitino.meta.CatalogEntity;
import org.apache.gravitino.storage.relational.mapper.CatalogMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetVersionMapper;
import org.apache.gravitino.storage.relational.mapper.GroupMetaMapper;
import org.apache.gravitino.storage.relational.mapper.GroupRoleRelMapper;
import org.apache.gravitino.storage.relational.mapper.MetalakeMetaMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.RoleMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SchemaMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.TopicMetaMapper;
import org.apache.gravitino.storage.relational.mapper.UserMetaMapper;
import org.apache.gravitino.storage.relational.mapper.UserRoleRelMapper;
import org.apache.gravitino.storage.relational.po.MetalakePO;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;

public class MetalakeMetaService {
    private static final MetalakeMetaService INSTANCE = new MetalakeMetaService();

    public static MetalakeMetaService getInstance() {
        return INSTANCE;
    }

    private MetalakeMetaService() {
    }

    public List<BaseMetalake> listMetalakes() {
        List metalakePOS = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, MetalakeMetaMapper::listMetalakePOs);
        return POConverters.fromMetalakePOs(metalakePOS);
    }

    public Long getMetalakeIdByName(String metalakeName) {
        Long metalakeId = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.selectMetalakeIdMetaByName(metalakeName));
        if (metalakeId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.METALAKE.name().toLowerCase(), metalakeName});
        }
        return metalakeId;
    }

    public BaseMetalake getMetalakeByIdentifier(NameIdentifier ident) {
        NameIdentifierUtil.checkMetalake(ident);
        MetalakePO metalakePO = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.selectMetalakeMetaByName(ident.name()));
        if (metalakePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.METALAKE.name().toLowerCase(), ident.toString()});
        }
        return POConverters.fromMetalakePO(metalakePO);
    }

    public MetalakePO getMetalakePOById(Long id) {
        MetalakePO metalakePO = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.selectMetalakeMetaById(id));
        return metalakePO;
    }

    public void insertMetalake(BaseMetalake baseMetalake, boolean overwrite) throws IOException {
        try {
            NameIdentifierUtil.checkMetalake(baseMetalake.nameIdentifier());
            SessionUtils.doWithCommit(MetalakeMetaMapper.class, mapper -> {
                MetalakePO po = POConverters.initializeMetalakePOWithVersion(baseMetalake);
                if (overwrite) {
                    mapper.insertMetalakeMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertMetalakeMeta(po);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.METALAKE, baseMetalake.nameIdentifier().toString());
            throw re;
        }
    }

    public <E extends Entity & HasIdentifier> BaseMetalake updateMetalake(NameIdentifier ident, Function<E, E> updater) throws IOException {
        Integer updateResult;
        NameIdentifierUtil.checkMetalake(ident);
        MetalakePO oldMetalakePO = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.selectMetalakeMetaByName(ident.name()));
        if (oldMetalakePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.METALAKE.name().toLowerCase(), ident.toString()});
        }
        BaseMetalake oldMetalakeEntity = POConverters.fromMetalakePO(oldMetalakePO);
        BaseMetalake newMetalakeEntity = (BaseMetalake)updater.apply(oldMetalakeEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldMetalakeEntity.id(), newMetalakeEntity.id()), (String)"The updated metalake entity id: %s should be same with the metalake entity id before: %s", (Object)newMetalakeEntity.id(), (Object)oldMetalakeEntity.id());
        MetalakePO newMetalakePO = POConverters.updateMetalakePOWithVersion(oldMetalakePO, newMetalakeEntity);
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(MetalakeMetaMapper.class, mapper -> mapper.updateMetalakeMeta(newMetalakePO, oldMetalakePO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.METALAKE, newMetalakeEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newMetalakeEntity;
        }
        throw new IOException("Failed to update the entity: " + ident);
    }

    public boolean deleteMetalake(NameIdentifier ident, boolean cascade) {
        NameIdentifierUtil.checkMetalake(ident);
        Long metalakeId = this.getMetalakeIdByName(ident.name());
        if (metalakeId != null) {
            if (cascade) {
                SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.softDeleteMetalakeMetaByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.softDeleteCatalogMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.softDeleteSchemaMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TableMetaMapper.class, mapper -> mapper.softDeleteTableMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.softDeleteFilesetMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.softDeleteFilesetVersionsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TopicMetaMapper.class, mapper -> mapper.softDeleteTopicMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.softDeleteUserRoleRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(UserMetaMapper.class, mapper -> mapper.softDeleteUserMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.softDeleteGroupRoleRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(GroupMetaMapper.class, mapper -> mapper.softDeleteGroupMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(RoleMetaMapper.class, mapper -> mapper.softDeleteRoleMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteRoleMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TagMetaMapper.class, mapper -> mapper.softDeleteTagMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetalakeId(metalakeId)));
            } else {
                List<CatalogEntity> catalogEntities = CatalogMetaService.getInstance().listCatalogsByNamespace(NamespaceUtil.ofCatalog(ident.name()));
                if (!catalogEntities.isEmpty()) {
                    throw new NonEmptyEntityException("Entity %s has sub-entities, you should remove sub-entities first", new Object[]{ident});
                }
                SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.softDeleteMetalakeMetaByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.softDeleteUserRoleRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(UserMetaMapper.class, mapper -> mapper.softDeleteUserMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.softDeleteGroupRoleRelByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(GroupMetaMapper.class, mapper -> mapper.softDeleteGroupMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(RoleMetaMapper.class, mapper -> mapper.softDeleteRoleMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteRoleMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TagMetaMapper.class, mapper -> mapper.softDeleteTagMetasByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetalakeId(metalakeId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetalakeId(metalakeId)));
            }
        }
        return true;
    }

    public int deleteMetalakeMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        int[] metalakeDeleteCount = new int[]{0};
        int[] ownerRelDeleteCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            metalakeDeleteCount[0] = SessionUtils.doWithCommitAndFetchResult(MetalakeMetaMapper.class, mapper -> mapper.deleteMetalakeMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            ownerRelDeleteCount[0] = SessionUtils.doWithCommitAndFetchResult(OwnerMetaMapper.class, mapper -> mapper.deleteOwnerMetasByLegacyTimeline(legacyTimeline, limit));
        });
        return metalakeDeleteCount[0] + ownerRelDeleteCount[0];
    }
}

