/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.mysql;

import com.google.common.collect.Maps;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.session.PropertyMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLDataTypeTransformer;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLTablePropertyConverter;
import org.apache.gravitino.trino.connector.metadata.GravitinoColumn;
import org.apache.gravitino.trino.connector.metadata.GravitinoTable;

public class MySQLMetadataAdapter
extends CatalogConnectorMetadataAdapter {
    private final PropertyConverter tableConverter = new MySQLTablePropertyConverter();

    public MySQLMetadataAdapter(List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> columnProperties) {
        super(schemaProperties, tableProperties, columnProperties, new MySQLDataTypeTransformer());
    }

    @Override
    public Map<String, String> toGravitinoTableProperties(Map<String, Object> properties) {
        Map stringMap = this.tableConverter.engineToGravitinoProperties(properties);
        return super.toGravitinoTableProperties(stringMap);
    }

    @Override
    public Map<String, Object> toTrinoTableProperties(Map<String, String> properties) {
        Map objectMap = this.tableConverter.gravitinoToEngineProperties(properties);
        return super.toTrinoTableProperties(objectMap);
    }

    @Override
    public GravitinoTable createTable(ConnectorTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableSchema().getTable().getTableName();
        String schemaName = tableMetadata.getTableSchema().getTable().getSchemaName();
        String comment = tableMetadata.getComment().orElse("");
        Map<String, String> properties = this.toGravitinoTableProperties(tableMetadata.getProperties());
        ArrayList<GravitinoColumn> columns = new ArrayList<GravitinoColumn>();
        for (int i = 0; i < tableMetadata.getColumns().size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableMetadata.getColumns().get(i);
            boolean autoIncrement = column.getProperties().getOrDefault("auto_increment", false);
            columns.add(new GravitinoColumn(column.getName(), this.dataTypeTransformer.getGravitinoType(column.getType()), i, column.getComment(), column.isNullable(), autoIncrement, column.getProperties()));
        }
        return new GravitinoTable(schemaName, tableName, columns, comment, properties);
    }

    @Override
    public ColumnMetadata getColumnMetadata(GravitinoColumn column) {
        HashMap propertyMap = Maps.newHashMap(column.getProperties());
        if (column.isAutoIncrement()) {
            propertyMap.put("auto_increment", true);
        }
        return ColumnMetadata.builder().setName(column.getName()).setType(this.dataTypeTransformer.getTrinoType(column.getType())).setComment(Optional.ofNullable(column.getComment())).setNullable(column.isNullable()).setHidden(column.isHidden()).setProperties((Map)propertyMap).build();
    }
}

